/*
* hal_pnl_reg.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/


#ifndef __HAL_PNL_REG_H__
#define __HAL_PNL_REG_H__

#define REG_LPLL_BASE           0x103300UL
#define REG_CHIPTOP_BASE        0x101E00UL
#define REG_CLKGEN_BASE         0x103800UL
#define REG_DISP_TOP_BASE       0x112800UL
#define REG_DISP_TOP_OP2_BASE   0x112900UL
#define REG_SC_CTRL_BASE        0x113300UL
#define REG_DPHY_BASE           0x152800UL

#define REG_PM_TOP_BASE         0x001E00UL

#ifndef REG_TABLE_END
#define REG_TABLE_END       0xFFFF
#endif

//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
#define REG_CHIPTOP_00_L     (REG_CHIPTOP_BASE + 0x00)
#define REG_CHIPTOP_00_H     (REG_CHIPTOP_BASE + 0x01)
#define REG_CHIPTOP_01_L     (REG_CHIPTOP_BASE + 0x02)
#define REG_CHIPTOP_01_H     (REG_CHIPTOP_BASE + 0x03)
#define REG_CHIPTOP_02_L     (REG_CHIPTOP_BASE + 0x04)
#define REG_CHIPTOP_02_H     (REG_CHIPTOP_BASE + 0x05)
#define REG_CHIPTOP_03_L     (REG_CHIPTOP_BASE + 0x06)
#define REG_CHIPTOP_03_H     (REG_CHIPTOP_BASE + 0x07)
#define REG_CHIPTOP_04_L     (REG_CHIPTOP_BASE + 0x08)
#define REG_CHIPTOP_04_H     (REG_CHIPTOP_BASE + 0x09)
#define REG_CHIPTOP_05_L     (REG_CHIPTOP_BASE + 0x0A)
#define REG_CHIPTOP_05_H     (REG_CHIPTOP_BASE + 0x0B)
#define REG_CHIPTOP_06_L     (REG_CHIPTOP_BASE + 0x0C)
#define REG_CHIPTOP_06_H     (REG_CHIPTOP_BASE + 0x0D)
#define REG_CHIPTOP_07_L     (REG_CHIPTOP_BASE + 0x0E)
#define REG_CHIPTOP_07_H     (REG_CHIPTOP_BASE + 0x0F)
#define REG_CHIPTOP_08_L     (REG_CHIPTOP_BASE + 0x10)
#define REG_CHIPTOP_08_H     (REG_CHIPTOP_BASE + 0x11)
#define REG_CHIPTOP_09_L     (REG_CHIPTOP_BASE + 0x12)
#define REG_CHIPTOP_09_H     (REG_CHIPTOP_BASE + 0x13)
#define REG_CHIPTOP_0A_L     (REG_CHIPTOP_BASE + 0x14)
#define REG_CHIPTOP_0A_H     (REG_CHIPTOP_BASE + 0x15)
#define REG_CHIPTOP_0B_L     (REG_CHIPTOP_BASE + 0x16)
#define REG_CHIPTOP_0B_H     (REG_CHIPTOP_BASE + 0x17)
#define REG_CHIPTOP_0C_L     (REG_CHIPTOP_BASE + 0x18)
#define REG_CHIPTOP_0C_H     (REG_CHIPTOP_BASE + 0x19)
#define REG_CHIPTOP_0D_L     (REG_CHIPTOP_BASE + 0x1A)
#define REG_CHIPTOP_0D_H     (REG_CHIPTOP_BASE + 0x1B)
#define REG_CHIPTOP_0E_L     (REG_CHIPTOP_BASE + 0x1C)
#define REG_CHIPTOP_0E_H     (REG_CHIPTOP_BASE + 0x1D)
#define REG_CHIPTOP_0F_L     (REG_CHIPTOP_BASE + 0x1E)
#define REG_CHIPTOP_0F_H     (REG_CHIPTOP_BASE + 0x1F)
#define REG_CHIPTOP_10_L     (REG_CHIPTOP_BASE + 0x20)
#define REG_CHIPTOP_10_H     (REG_CHIPTOP_BASE + 0x21)
#define REG_CHIPTOP_11_L     (REG_CHIPTOP_BASE + 0x22)
#define REG_CHIPTOP_11_H     (REG_CHIPTOP_BASE + 0x23)
#define REG_CHIPTOP_12_L     (REG_CHIPTOP_BASE + 0x24)
#define REG_CHIPTOP_12_H     (REG_CHIPTOP_BASE + 0x25)
#define REG_CHIPTOP_13_L     (REG_CHIPTOP_BASE + 0x26)
#define REG_CHIPTOP_13_H     (REG_CHIPTOP_BASE + 0x27)
#define REG_CHIPTOP_14_L     (REG_CHIPTOP_BASE + 0x28)
#define REG_CHIPTOP_14_H     (REG_CHIPTOP_BASE + 0x29)
#define REG_CHIPTOP_15_L     (REG_CHIPTOP_BASE + 0x2A)
#define REG_CHIPTOP_15_H     (REG_CHIPTOP_BASE + 0x2B)
#define REG_CHIPTOP_16_L     (REG_CHIPTOP_BASE + 0x2C)
#define REG_CHIPTOP_16_H     (REG_CHIPTOP_BASE + 0x2D)
#define REG_CHIPTOP_17_L     (REG_CHIPTOP_BASE + 0x2E)
#define REG_CHIPTOP_17_H     (REG_CHIPTOP_BASE + 0x2F)
#define REG_CHIPTOP_18_L     (REG_CHIPTOP_BASE + 0x30)
#define REG_CHIPTOP_18_H     (REG_CHIPTOP_BASE + 0x31)
#define REG_CHIPTOP_19_L     (REG_CHIPTOP_BASE + 0x32)
#define REG_CHIPTOP_19_H     (REG_CHIPTOP_BASE + 0x33)
#define REG_CHIPTOP_1A_L     (REG_CHIPTOP_BASE + 0x34)
#define REG_CHIPTOP_1A_H     (REG_CHIPTOP_BASE + 0x35)
#define REG_CHIPTOP_1B_L     (REG_CHIPTOP_BASE + 0x36)
#define REG_CHIPTOP_1B_H     (REG_CHIPTOP_BASE + 0x37)
#define REG_CHIPTOP_1C_L     (REG_CHIPTOP_BASE + 0x38)
#define REG_CHIPTOP_1C_H     (REG_CHIPTOP_BASE + 0x39)
#define REG_CHIPTOP_1D_L     (REG_CHIPTOP_BASE + 0x3A)
#define REG_CHIPTOP_1D_H     (REG_CHIPTOP_BASE + 0x3B)
#define REG_CHIPTOP_1E_L     (REG_CHIPTOP_BASE + 0x3C)
#define REG_CHIPTOP_1E_H     (REG_CHIPTOP_BASE + 0x3D)
#define REG_CHIPTOP_1F_L     (REG_CHIPTOP_BASE + 0x3E)
#define REG_CHIPTOP_1F_H     (REG_CHIPTOP_BASE + 0x3F)
#define REG_CHIPTOP_20_L     (REG_CHIPTOP_BASE + 0x40)
#define REG_CHIPTOP_20_H     (REG_CHIPTOP_BASE + 0x41)
#define REG_CHIPTOP_21_L     (REG_CHIPTOP_BASE + 0x42)
#define REG_CHIPTOP_21_H     (REG_CHIPTOP_BASE + 0x43)
#define REG_CHIPTOP_22_L     (REG_CHIPTOP_BASE + 0x44)
#define REG_CHIPTOP_22_H     (REG_CHIPTOP_BASE + 0x45)
#define REG_CHIPTOP_23_L     (REG_CHIPTOP_BASE + 0x46)
#define REG_CHIPTOP_23_H     (REG_CHIPTOP_BASE + 0x47)
#define REG_CHIPTOP_24_L     (REG_CHIPTOP_BASE + 0x48)
#define REG_CHIPTOP_24_H     (REG_CHIPTOP_BASE + 0x49)
#define REG_CHIPTOP_25_L     (REG_CHIPTOP_BASE + 0x4A)
#define REG_CHIPTOP_25_H     (REG_CHIPTOP_BASE + 0x4B)
#define REG_CHIPTOP_26_L     (REG_CHIPTOP_BASE + 0x4C)
#define REG_CHIPTOP_26_H     (REG_CHIPTOP_BASE + 0x4D)
#define REG_CHIPTOP_27_L     (REG_CHIPTOP_BASE + 0x4E)
#define REG_CHIPTOP_27_H     (REG_CHIPTOP_BASE + 0x4F)
#define REG_CHIPTOP_28_L     (REG_CHIPTOP_BASE + 0x50)
#define REG_CHIPTOP_28_H     (REG_CHIPTOP_BASE + 0x51)
#define REG_CHIPTOP_29_L     (REG_CHIPTOP_BASE + 0x52)
#define REG_CHIPTOP_29_H     (REG_CHIPTOP_BASE + 0x53)
#define REG_CHIPTOP_2A_L     (REG_CHIPTOP_BASE + 0x54)
#define REG_CHIPTOP_2A_H     (REG_CHIPTOP_BASE + 0x55)
#define REG_CHIPTOP_2B_L     (REG_CHIPTOP_BASE + 0x56)
#define REG_CHIPTOP_2B_H     (REG_CHIPTOP_BASE + 0x57)
#define REG_CHIPTOP_2C_L     (REG_CHIPTOP_BASE + 0x58)
#define REG_CHIPTOP_2C_H     (REG_CHIPTOP_BASE + 0x59)
#define REG_CHIPTOP_2D_L     (REG_CHIPTOP_BASE + 0x5A)
#define REG_CHIPTOP_2D_H     (REG_CHIPTOP_BASE + 0x5B)
#define REG_CHIPTOP_2E_L     (REG_CHIPTOP_BASE + 0x5C)
#define REG_CHIPTOP_2E_H     (REG_CHIPTOP_BASE + 0x5D)
#define REG_CHIPTOP_2F_L     (REG_CHIPTOP_BASE + 0x5E)
#define REG_CHIPTOP_2F_H     (REG_CHIPTOP_BASE + 0x5F)
#define REG_CHIPTOP_30_L     (REG_CHIPTOP_BASE + 0x60)
#define REG_CHIPTOP_30_H     (REG_CHIPTOP_BASE + 0x61)
#define REG_CHIPTOP_31_L     (REG_CHIPTOP_BASE + 0x62)
#define REG_CHIPTOP_31_H     (REG_CHIPTOP_BASE + 0x63)
#define REG_CHIPTOP_32_L     (REG_CHIPTOP_BASE + 0x64)
#define REG_CHIPTOP_32_H     (REG_CHIPTOP_BASE + 0x65)
#define REG_CHIPTOP_33_L     (REG_CHIPTOP_BASE + 0x66)
#define REG_CHIPTOP_33_H     (REG_CHIPTOP_BASE + 0x67)
#define REG_CHIPTOP_34_L     (REG_CHIPTOP_BASE + 0x68)
#define REG_CHIPTOP_34_H     (REG_CHIPTOP_BASE + 0x69)
#define REG_CHIPTOP_35_L     (REG_CHIPTOP_BASE + 0x6A)
#define REG_CHIPTOP_35_H     (REG_CHIPTOP_BASE + 0x6B)
#define REG_CHIPTOP_36_L     (REG_CHIPTOP_BASE + 0x6C)
#define REG_CHIPTOP_36_H     (REG_CHIPTOP_BASE + 0x6D)
#define REG_CHIPTOP_37_L     (REG_CHIPTOP_BASE + 0x6E)
#define REG_CHIPTOP_37_H     (REG_CHIPTOP_BASE + 0x6F)
#define REG_CHIPTOP_38_L     (REG_CHIPTOP_BASE + 0x70)
#define REG_CHIPTOP_38_H     (REG_CHIPTOP_BASE + 0x71)
#define REG_CHIPTOP_39_L     (REG_CHIPTOP_BASE + 0x72)
#define REG_CHIPTOP_39_H     (REG_CHIPTOP_BASE + 0x73)
#define REG_CHIPTOP_3A_L     (REG_CHIPTOP_BASE + 0x74)
#define REG_CHIPTOP_3A_H     (REG_CHIPTOP_BASE + 0x75)
#define REG_CHIPTOP_3B_L     (REG_CHIPTOP_BASE + 0x76)
#define REG_CHIPTOP_3B_H     (REG_CHIPTOP_BASE + 0x77)
#define REG_CHIPTOP_3C_L     (REG_CHIPTOP_BASE + 0x78)
#define REG_CHIPTOP_3C_H     (REG_CHIPTOP_BASE + 0x79)
#define REG_CHIPTOP_3D_L     (REG_CHIPTOP_BASE + 0x7A)
#define REG_CHIPTOP_3D_H     (REG_CHIPTOP_BASE + 0x7B)
#define REG_CHIPTOP_3E_L     (REG_CHIPTOP_BASE + 0x7C)
#define REG_CHIPTOP_3E_H     (REG_CHIPTOP_BASE + 0x7D)
#define REG_CHIPTOP_3F_L     (REG_CHIPTOP_BASE + 0x7E)
#define REG_CHIPTOP_3F_H     (REG_CHIPTOP_BASE + 0x7F)
#define REG_CHIPTOP_40_L     (REG_CHIPTOP_BASE + 0x80)
#define REG_CHIPTOP_40_H     (REG_CHIPTOP_BASE + 0x81)
#define REG_CHIPTOP_41_L     (REG_CHIPTOP_BASE + 0x82)
#define REG_CHIPTOP_41_H     (REG_CHIPTOP_BASE + 0x83)
#define REG_CHIPTOP_42_L     (REG_CHIPTOP_BASE + 0x84)
#define REG_CHIPTOP_42_H     (REG_CHIPTOP_BASE + 0x85)
#define REG_CHIPTOP_43_L     (REG_CHIPTOP_BASE + 0x86)
#define REG_CHIPTOP_43_H     (REG_CHIPTOP_BASE + 0x87)
#define REG_CHIPTOP_44_L     (REG_CHIPTOP_BASE + 0x88)
#define REG_CHIPTOP_44_H     (REG_CHIPTOP_BASE + 0x89)
#define REG_CHIPTOP_45_L     (REG_CHIPTOP_BASE + 0x8A)
#define REG_CHIPTOP_45_H     (REG_CHIPTOP_BASE + 0x8B)
#define REG_CHIPTOP_46_L     (REG_CHIPTOP_BASE + 0x8C)
#define REG_CHIPTOP_46_H     (REG_CHIPTOP_BASE + 0x8D)
#define REG_CHIPTOP_47_L     (REG_CHIPTOP_BASE + 0x8E)
#define REG_CHIPTOP_47_H     (REG_CHIPTOP_BASE + 0x8F)
#define REG_CHIPTOP_48_L     (REG_CHIPTOP_BASE + 0x90)
#define REG_CHIPTOP_48_H     (REG_CHIPTOP_BASE + 0x91)
#define REG_CHIPTOP_49_L     (REG_CHIPTOP_BASE + 0x92)
#define REG_CHIPTOP_49_H     (REG_CHIPTOP_BASE + 0x93)
#define REG_CHIPTOP_4A_L     (REG_CHIPTOP_BASE + 0x94)
#define REG_CHIPTOP_4A_H     (REG_CHIPTOP_BASE + 0x95)
#define REG_CHIPTOP_4B_L     (REG_CHIPTOP_BASE + 0x96)
#define REG_CHIPTOP_4B_H     (REG_CHIPTOP_BASE + 0x97)
#define REG_CHIPTOP_4C_L     (REG_CHIPTOP_BASE + 0x98)
#define REG_CHIPTOP_4C_H     (REG_CHIPTOP_BASE + 0x99)
#define REG_CHIPTOP_4D_L     (REG_CHIPTOP_BASE + 0x9A)
#define REG_CHIPTOP_4D_H     (REG_CHIPTOP_BASE + 0x9B)
#define REG_CHIPTOP_4E_L     (REG_CHIPTOP_BASE + 0x9C)
#define REG_CHIPTOP_4E_H     (REG_CHIPTOP_BASE + 0x9D)
#define REG_CHIPTOP_4F_L     (REG_CHIPTOP_BASE + 0x9E)
#define REG_CHIPTOP_4F_H     (REG_CHIPTOP_BASE + 0x9F)
#define REG_CHIPTOP_50_L     (REG_CHIPTOP_BASE + 0xA0)
#define REG_CHIPTOP_50_H     (REG_CHIPTOP_BASE + 0xA1)
#define REG_CHIPTOP_51_L     (REG_CHIPTOP_BASE + 0xA2)
#define REG_CHIPTOP_51_H     (REG_CHIPTOP_BASE + 0xA3)
#define REG_CHIPTOP_52_L     (REG_CHIPTOP_BASE + 0xA4)
#define REG_CHIPTOP_52_H     (REG_CHIPTOP_BASE + 0xA5)
#define REG_CHIPTOP_53_L     (REG_CHIPTOP_BASE + 0xA6)
#define REG_CHIPTOP_53_H     (REG_CHIPTOP_BASE + 0xA7)
#define REG_CHIPTOP_54_L     (REG_CHIPTOP_BASE + 0xA8)
#define REG_CHIPTOP_54_H     (REG_CHIPTOP_BASE + 0xA9)
#define REG_CHIPTOP_55_L     (REG_CHIPTOP_BASE + 0xAA)
#define REG_CHIPTOP_55_H     (REG_CHIPTOP_BASE + 0xAB)
#define REG_CHIPTOP_56_L     (REG_CHIPTOP_BASE + 0xAC)
#define REG_CHIPTOP_56_H     (REG_CHIPTOP_BASE + 0xAD)
#define REG_CHIPTOP_57_L     (REG_CHIPTOP_BASE + 0xAE)
#define REG_CHIPTOP_57_H     (REG_CHIPTOP_BASE + 0xAF)
#define REG_CHIPTOP_58_L     (REG_CHIPTOP_BASE + 0xB0)
#define REG_CHIPTOP_58_H     (REG_CHIPTOP_BASE + 0xB1)
#define REG_CHIPTOP_59_L     (REG_CHIPTOP_BASE + 0xB2)
#define REG_CHIPTOP_59_H     (REG_CHIPTOP_BASE + 0xB3)
#define REG_CHIPTOP_5A_L     (REG_CHIPTOP_BASE + 0xB4)
#define REG_CHIPTOP_5A_H     (REG_CHIPTOP_BASE + 0xB5)
#define REG_CHIPTOP_5B_L     (REG_CHIPTOP_BASE + 0xB6)
#define REG_CHIPTOP_5B_H     (REG_CHIPTOP_BASE + 0xB7)
#define REG_CHIPTOP_5C_L     (REG_CHIPTOP_BASE + 0xB8)
#define REG_CHIPTOP_5C_H     (REG_CHIPTOP_BASE + 0xB9)
#define REG_CHIPTOP_5D_L     (REG_CHIPTOP_BASE + 0xBA)
#define REG_CHIPTOP_5D_H     (REG_CHIPTOP_BASE + 0xBB)
#define REG_CHIPTOP_5E_L     (REG_CHIPTOP_BASE + 0xBC)
#define REG_CHIPTOP_5E_H     (REG_CHIPTOP_BASE + 0xBD)
#define REG_CHIPTOP_5F_L     (REG_CHIPTOP_BASE + 0xBE)
#define REG_CHIPTOP_5F_H     (REG_CHIPTOP_BASE + 0xBF)
#define REG_CHIPTOP_60_L     (REG_CHIPTOP_BASE + 0xC0)
#define REG_CHIPTOP_60_H     (REG_CHIPTOP_BASE + 0xC1)
#define REG_CHIPTOP_61_L     (REG_CHIPTOP_BASE + 0xC2)
#define REG_CHIPTOP_61_H     (REG_CHIPTOP_BASE + 0xC3)
#define REG_CHIPTOP_62_L     (REG_CHIPTOP_BASE + 0xC4)
#define REG_CHIPTOP_62_H     (REG_CHIPTOP_BASE + 0xC5)
#define REG_CHIPTOP_63_L     (REG_CHIPTOP_BASE + 0xC6)
#define REG_CHIPTOP_63_H     (REG_CHIPTOP_BASE + 0xC7)
#define REG_CHIPTOP_64_L     (REG_CHIPTOP_BASE + 0xC8)
#define REG_CHIPTOP_64_H     (REG_CHIPTOP_BASE + 0xC9)
#define REG_CHIPTOP_65_L     (REG_CHIPTOP_BASE + 0xCA)
#define REG_CHIPTOP_65_H     (REG_CHIPTOP_BASE + 0xCB)
#define REG_CHIPTOP_66_L     (REG_CHIPTOP_BASE + 0xCC)
#define REG_CHIPTOP_66_H     (REG_CHIPTOP_BASE + 0xCD)
#define REG_CHIPTOP_67_L     (REG_CHIPTOP_BASE + 0xCE)
#define REG_CHIPTOP_67_H     (REG_CHIPTOP_BASE + 0xCF)
#define REG_CHIPTOP_68_L     (REG_CHIPTOP_BASE + 0xD0)
#define REG_CHIPTOP_68_H     (REG_CHIPTOP_BASE + 0xD1)
#define REG_CHIPTOP_69_L     (REG_CHIPTOP_BASE + 0xD2)
#define REG_CHIPTOP_69_H     (REG_CHIPTOP_BASE + 0xD3)
#define REG_CHIPTOP_6A_L     (REG_CHIPTOP_BASE + 0xD4)
#define REG_CHIPTOP_6A_H     (REG_CHIPTOP_BASE + 0xD5)
#define REG_CHIPTOP_6B_L     (REG_CHIPTOP_BASE + 0xD6)
#define REG_CHIPTOP_6B_H     (REG_CHIPTOP_BASE + 0xD7)
#define REG_CHIPTOP_6C_L     (REG_CHIPTOP_BASE + 0xD8)
#define REG_CHIPTOP_6C_H     (REG_CHIPTOP_BASE + 0xD9)
#define REG_CHIPTOP_6D_L     (REG_CHIPTOP_BASE + 0xDA)
#define REG_CHIPTOP_6D_H     (REG_CHIPTOP_BASE + 0xDB)
#define REG_CHIPTOP_6E_L     (REG_CHIPTOP_BASE + 0xDC)
#define REG_CHIPTOP_6E_H     (REG_CHIPTOP_BASE + 0xDD)
#define REG_CHIPTOP_6F_L     (REG_CHIPTOP_BASE + 0xDE)
#define REG_CHIPTOP_6F_H     (REG_CHIPTOP_BASE + 0xDF)
#define REG_CHIPTOP_70_L     (REG_CHIPTOP_BASE + 0xE0)
#define REG_CHIPTOP_70_H     (REG_CHIPTOP_BASE + 0xE1)
#define REG_CHIPTOP_71_L     (REG_CHIPTOP_BASE + 0xE2)
#define REG_CHIPTOP_71_H     (REG_CHIPTOP_BASE + 0xE3)
#define REG_CHIPTOP_72_L     (REG_CHIPTOP_BASE + 0xE4)
#define REG_CHIPTOP_72_H     (REG_CHIPTOP_BASE + 0xE5)
#define REG_CHIPTOP_73_L     (REG_CHIPTOP_BASE + 0xE6)
#define REG_CHIPTOP_73_H     (REG_CHIPTOP_BASE + 0xE7)
#define REG_CHIPTOP_74_L     (REG_CHIPTOP_BASE + 0xE8)
#define REG_CHIPTOP_74_H     (REG_CHIPTOP_BASE + 0xE9)
#define REG_CHIPTOP_75_L     (REG_CHIPTOP_BASE + 0xEA)
#define REG_CHIPTOP_75_H     (REG_CHIPTOP_BASE + 0xEB)
#define REG_CHIPTOP_76_L     (REG_CHIPTOP_BASE + 0xEC)
#define REG_CHIPTOP_76_H     (REG_CHIPTOP_BASE + 0xED)
#define REG_CHIPTOP_77_L     (REG_CHIPTOP_BASE + 0xEE)
#define REG_CHIPTOP_77_H     (REG_CHIPTOP_BASE + 0xEF)
#define REG_CHIPTOP_78_L     (REG_CHIPTOP_BASE + 0xF0)
#define REG_CHIPTOP_78_H     (REG_CHIPTOP_BASE + 0xF1)
#define REG_CHIPTOP_79_L     (REG_CHIPTOP_BASE + 0xF2)
#define REG_CHIPTOP_79_H     (REG_CHIPTOP_BASE + 0xF3)
#define REG_CHIPTOP_7A_L     (REG_CHIPTOP_BASE + 0xF4)
#define REG_CHIPTOP_7A_H     (REG_CHIPTOP_BASE + 0xF5)
#define REG_CHIPTOP_7B_L     (REG_CHIPTOP_BASE + 0xF6)
#define REG_CHIPTOP_7B_H     (REG_CHIPTOP_BASE + 0xF7)
#define REG_CHIPTOP_7C_L     (REG_CHIPTOP_BASE + 0xF8)
#define REG_CHIPTOP_7C_H     (REG_CHIPTOP_BASE + 0xF9)
#define REG_CHIPTOP_7D_L     (REG_CHIPTOP_BASE + 0xFA)
#define REG_CHIPTOP_7D_H     (REG_CHIPTOP_BASE + 0xFB)
#define REG_CHIPTOP_7E_L     (REG_CHIPTOP_BASE + 0xFC)
#define REG_CHIPTOP_7E_H     (REG_CHIPTOP_BASE + 0xFD)
#define REG_CHIPTOP_7F_L     (REG_CHIPTOP_BASE + 0xFE)
#define REG_CHIPTOP_7F_H     (REG_CHIPTOP_BASE + 0xFF)


#define REG_LPLL_00_L    (REG_LPLL_BASE + 0x00)
#define REG_LPLL_00_H    (REG_LPLL_BASE + 0x01)
#define REG_LPLL_01_L    (REG_LPLL_BASE + 0x02)
#define REG_LPLL_01_H    (REG_LPLL_BASE + 0x03)
#define REG_LPLL_02_L    (REG_LPLL_BASE + 0x04)
#define REG_LPLL_02_H    (REG_LPLL_BASE + 0x05)
#define REG_LPLL_03_L    (REG_LPLL_BASE + 0x06)
#define REG_LPLL_03_H    (REG_LPLL_BASE + 0x07)
#define REG_LPLL_04_L    (REG_LPLL_BASE + 0x08)
#define REG_LPLL_04_H    (REG_LPLL_BASE + 0x09)
#define REG_LPLL_05_L    (REG_LPLL_BASE + 0x0A)
#define REG_LPLL_05_H    (REG_LPLL_BASE + 0x0B)
#define REG_LPLL_06_L    (REG_LPLL_BASE + 0x0C)
#define REG_LPLL_06_H    (REG_LPLL_BASE + 0x0D)
#define REG_LPLL_07_L    (REG_LPLL_BASE + 0x0E)
#define REG_LPLL_07_H    (REG_LPLL_BASE + 0x0F)
#define REG_LPLL_08_L    (REG_LPLL_BASE + 0x10)
#define REG_LPLL_08_H    (REG_LPLL_BASE + 0x11)
#define REG_LPLL_09_L    (REG_LPLL_BASE + 0x12)
#define REG_LPLL_09_H    (REG_LPLL_BASE + 0x13)
#define REG_LPLL_0A_L    (REG_LPLL_BASE + 0x14)
#define REG_LPLL_0A_H    (REG_LPLL_BASE + 0x15)
#define REG_LPLL_0B_L    (REG_LPLL_BASE + 0x16)
#define REG_LPLL_0B_H    (REG_LPLL_BASE + 0x17)
#define REG_LPLL_0C_L    (REG_LPLL_BASE + 0x18)
#define REG_LPLL_0C_H    (REG_LPLL_BASE + 0x19)
#define REG_LPLL_0D_L    (REG_LPLL_BASE + 0x1A)
#define REG_LPLL_0D_H    (REG_LPLL_BASE + 0x1B)
#define REG_LPLL_0E_L    (REG_LPLL_BASE + 0x1C)
#define REG_LPLL_0E_H    (REG_LPLL_BASE + 0x1D)
#define REG_LPLL_0F_L    (REG_LPLL_BASE + 0x1E)
#define REG_LPLL_0F_H    (REG_LPLL_BASE + 0x1F)
#define REG_LPLL_10_L    (REG_LPLL_BASE + 0x20)
#define REG_LPLL_10_H    (REG_LPLL_BASE + 0x21)
#define REG_LPLL_11_L    (REG_LPLL_BASE + 0x22)
#define REG_LPLL_11_H    (REG_LPLL_BASE + 0x23)
#define REG_LPLL_12_L    (REG_LPLL_BASE + 0x24)
#define REG_LPLL_12_H    (REG_LPLL_BASE + 0x25)
#define REG_LPLL_13_L    (REG_LPLL_BASE + 0x26)
#define REG_LPLL_13_H    (REG_LPLL_BASE + 0x27)
#define REG_LPLL_14_L    (REG_LPLL_BASE + 0x28)
#define REG_LPLL_14_H    (REG_LPLL_BASE + 0x29)
#define REG_LPLL_15_L    (REG_LPLL_BASE + 0x2A)
#define REG_LPLL_15_H    (REG_LPLL_BASE + 0x2B)
#define REG_LPLL_16_L    (REG_LPLL_BASE + 0x2C)
#define REG_LPLL_16_H    (REG_LPLL_BASE + 0x2D)
#define REG_LPLL_17_L    (REG_LPLL_BASE + 0x2E)
#define REG_LPLL_17_H    (REG_LPLL_BASE + 0x2F)
#define REG_LPLL_18_L    (REG_LPLL_BASE + 0x30)
#define REG_LPLL_18_H    (REG_LPLL_BASE + 0x31)
#define REG_LPLL_19_L    (REG_LPLL_BASE + 0x32)
#define REG_LPLL_19_H    (REG_LPLL_BASE + 0x33)
#define REG_LPLL_1A_L    (REG_LPLL_BASE + 0x34)
#define REG_LPLL_1A_H    (REG_LPLL_BASE + 0x35)
#define REG_LPLL_1B_L    (REG_LPLL_BASE + 0x36)
#define REG_LPLL_1B_H    (REG_LPLL_BASE + 0x37)
#define REG_LPLL_1C_L    (REG_LPLL_BASE + 0x38)
#define REG_LPLL_1C_H    (REG_LPLL_BASE + 0x39)
#define REG_LPLL_1D_L    (REG_LPLL_BASE + 0x3A)
#define REG_LPLL_1D_H    (REG_LPLL_BASE + 0x3B)
#define REG_LPLL_1E_L    (REG_LPLL_BASE + 0x3C)
#define REG_LPLL_1E_H    (REG_LPLL_BASE + 0x3D)
#define REG_LPLL_1F_L    (REG_LPLL_BASE + 0x3E)
#define REG_LPLL_1F_H    (REG_LPLL_BASE + 0x3F)
#define REG_LPLL_20_L    (REG_LPLL_BASE + 0x40)
#define REG_LPLL_20_H    (REG_LPLL_BASE + 0x41)
#define REG_LPLL_21_L    (REG_LPLL_BASE + 0x42)
#define REG_LPLL_21_H    (REG_LPLL_BASE + 0x43)
#define REG_LPLL_22_L    (REG_LPLL_BASE + 0x44)
#define REG_LPLL_22_H    (REG_LPLL_BASE + 0x45)
#define REG_LPLL_23_L    (REG_LPLL_BASE + 0x46)
#define REG_LPLL_23_H    (REG_LPLL_BASE + 0x47)
#define REG_LPLL_24_L    (REG_LPLL_BASE + 0x48)
#define REG_LPLL_24_H    (REG_LPLL_BASE + 0x49)
#define REG_LPLL_25_L    (REG_LPLL_BASE + 0x4A)
#define REG_LPLL_25_H    (REG_LPLL_BASE + 0x4B)
#define REG_LPLL_26_L    (REG_LPLL_BASE + 0x4C)
#define REG_LPLL_26_H    (REG_LPLL_BASE + 0x4D)
#define REG_LPLL_27_L    (REG_LPLL_BASE + 0x4E)
#define REG_LPLL_27_H    (REG_LPLL_BASE + 0x4F)
#define REG_LPLL_28_L    (REG_LPLL_BASE + 0x50)
#define REG_LPLL_28_H    (REG_LPLL_BASE + 0x51)
#define REG_LPLL_29_L    (REG_LPLL_BASE + 0x52)
#define REG_LPLL_29_H    (REG_LPLL_BASE + 0x53)
#define REG_LPLL_2A_L    (REG_LPLL_BASE + 0x54)
#define REG_LPLL_2A_H    (REG_LPLL_BASE + 0x55)
#define REG_LPLL_2B_L    (REG_LPLL_BASE + 0x56)
#define REG_LPLL_2B_H    (REG_LPLL_BASE + 0x57)
#define REG_LPLL_2C_L    (REG_LPLL_BASE + 0x58)
#define REG_LPLL_2C_H    (REG_LPLL_BASE + 0x59)
#define REG_LPLL_2D_L    (REG_LPLL_BASE + 0x5A)
#define REG_LPLL_2D_H    (REG_LPLL_BASE + 0x5B)
#define REG_LPLL_2E_L    (REG_LPLL_BASE + 0x5C)
#define REG_LPLL_2E_H    (REG_LPLL_BASE + 0x5D)
#define REG_LPLL_2F_L    (REG_LPLL_BASE + 0x5E)
#define REG_LPLL_2F_H    (REG_LPLL_BASE + 0x5F)
#define REG_LPLL_30_L    (REG_LPLL_BASE + 0x60)
#define REG_LPLL_30_H    (REG_LPLL_BASE + 0x61)
#define REG_LPLL_31_L    (REG_LPLL_BASE + 0x62)
#define REG_LPLL_31_H    (REG_LPLL_BASE + 0x63)
#define REG_LPLL_32_L    (REG_LPLL_BASE + 0x64)
#define REG_LPLL_32_H    (REG_LPLL_BASE + 0x65)
#define REG_LPLL_33_L    (REG_LPLL_BASE + 0x66)
#define REG_LPLL_33_H    (REG_LPLL_BASE + 0x67)
#define REG_LPLL_34_L    (REG_LPLL_BASE + 0x68)
#define REG_LPLL_34_H    (REG_LPLL_BASE + 0x69)
#define REG_LPLL_35_L    (REG_LPLL_BASE + 0x6A)
#define REG_LPLL_35_H    (REG_LPLL_BASE + 0x6B)
#define REG_LPLL_36_L    (REG_LPLL_BASE + 0x6C)
#define REG_LPLL_36_H    (REG_LPLL_BASE + 0x6D)
#define REG_LPLL_37_L    (REG_LPLL_BASE + 0x6E)
#define REG_LPLL_37_H    (REG_LPLL_BASE + 0x6F)
#define REG_LPLL_38_L    (REG_LPLL_BASE + 0x70)
#define REG_LPLL_38_H    (REG_LPLL_BASE + 0x71)
#define REG_LPLL_39_L    (REG_LPLL_BASE + 0x72)
#define REG_LPLL_39_H    (REG_LPLL_BASE + 0x73)
#define REG_LPLL_3A_L    (REG_LPLL_BASE + 0x74)
#define REG_LPLL_3A_H    (REG_LPLL_BASE + 0x75)
#define REG_LPLL_3B_L    (REG_LPLL_BASE + 0x76)
#define REG_LPLL_3B_H    (REG_LPLL_BASE + 0x77)
#define REG_LPLL_3C_L    (REG_LPLL_BASE + 0x78)
#define REG_LPLL_3C_H    (REG_LPLL_BASE + 0x79)
#define REG_LPLL_3D_L    (REG_LPLL_BASE + 0x7A)
#define REG_LPLL_3D_H    (REG_LPLL_BASE + 0x7B)
#define REG_LPLL_3E_L    (REG_LPLL_BASE + 0x7C)
#define REG_LPLL_3E_H    (REG_LPLL_BASE + 0x7D)
#define REG_LPLL_3F_L    (REG_LPLL_BASE + 0x7E)
#define REG_LPLL_3F_H    (REG_LPLL_BASE + 0x7F)
#define REG_LPLL_40_L    (REG_LPLL_BASE + 0x80)
#define REG_LPLL_40_H    (REG_LPLL_BASE + 0x81)
#define REG_LPLL_41_L    (REG_LPLL_BASE + 0x82)
#define REG_LPLL_41_H    (REG_LPLL_BASE + 0x83)
#define REG_LPLL_42_L    (REG_LPLL_BASE + 0x84)
#define REG_LPLL_42_H    (REG_LPLL_BASE + 0x85)
#define REG_LPLL_43_L    (REG_LPLL_BASE + 0x86)
#define REG_LPLL_43_H    (REG_LPLL_BASE + 0x87)
#define REG_LPLL_44_L    (REG_LPLL_BASE + 0x88)
#define REG_LPLL_44_H    (REG_LPLL_BASE + 0x89)
#define REG_LPLL_45_L    (REG_LPLL_BASE + 0x8A)
#define REG_LPLL_45_H    (REG_LPLL_BASE + 0x8B)
#define REG_LPLL_46_L    (REG_LPLL_BASE + 0x8C)
#define REG_LPLL_46_H    (REG_LPLL_BASE + 0x8D)
#define REG_LPLL_47_L    (REG_LPLL_BASE + 0x8E)
#define REG_LPLL_47_H    (REG_LPLL_BASE + 0x8F)
#define REG_LPLL_48_L    (REG_LPLL_BASE + 0x90)
#define REG_LPLL_48_H    (REG_LPLL_BASE + 0x91)
#define REG_LPLL_49_L    (REG_LPLL_BASE + 0x92)
#define REG_LPLL_49_H    (REG_LPLL_BASE + 0x93)
#define REG_LPLL_4A_L    (REG_LPLL_BASE + 0x94)
#define REG_LPLL_4A_H    (REG_LPLL_BASE + 0x95)
#define REG_LPLL_4B_L    (REG_LPLL_BASE + 0x96)
#define REG_LPLL_4B_H    (REG_LPLL_BASE + 0x97)
#define REG_LPLL_4C_L    (REG_LPLL_BASE + 0x98)
#define REG_LPLL_4C_H    (REG_LPLL_BASE + 0x99)
#define REG_LPLL_4D_L    (REG_LPLL_BASE + 0x9A)
#define REG_LPLL_4D_H    (REG_LPLL_BASE + 0x9B)
#define REG_LPLL_4E_L    (REG_LPLL_BASE + 0x9C)
#define REG_LPLL_4E_H    (REG_LPLL_BASE + 0x9D)
#define REG_LPLL_4F_L    (REG_LPLL_BASE + 0x9E)
#define REG_LPLL_4F_H    (REG_LPLL_BASE + 0x9F)
#define REG_LPLL_50_L    (REG_LPLL_BASE + 0xA0)
#define REG_LPLL_50_H    (REG_LPLL_BASE + 0xA1)
#define REG_LPLL_51_L    (REG_LPLL_BASE + 0xA2)
#define REG_LPLL_51_H    (REG_LPLL_BASE + 0xA3)
#define REG_LPLL_52_L    (REG_LPLL_BASE + 0xA4)
#define REG_LPLL_52_H    (REG_LPLL_BASE + 0xA5)
#define REG_LPLL_53_L    (REG_LPLL_BASE + 0xA6)
#define REG_LPLL_53_H    (REG_LPLL_BASE + 0xA7)
#define REG_LPLL_54_L    (REG_LPLL_BASE + 0xA8)
#define REG_LPLL_54_H    (REG_LPLL_BASE + 0xA9)
#define REG_LPLL_55_L    (REG_LPLL_BASE + 0xAA)
#define REG_LPLL_55_H    (REG_LPLL_BASE + 0xAB)
#define REG_LPLL_56_L    (REG_LPLL_BASE + 0xAC)
#define REG_LPLL_56_H    (REG_LPLL_BASE + 0xAD)
#define REG_LPLL_57_L    (REG_LPLL_BASE + 0xAE)
#define REG_LPLL_57_H    (REG_LPLL_BASE + 0xAF)
#define REG_LPLL_58_L    (REG_LPLL_BASE + 0xB0)
#define REG_LPLL_58_H    (REG_LPLL_BASE + 0xB1)
#define REG_LPLL_59_L    (REG_LPLL_BASE + 0xB2)
#define REG_LPLL_59_H    (REG_LPLL_BASE + 0xB3)
#define REG_LPLL_5A_L    (REG_LPLL_BASE + 0xB4)
#define REG_LPLL_5A_H    (REG_LPLL_BASE + 0xB5)
#define REG_LPLL_5B_L    (REG_LPLL_BASE + 0xB6)
#define REG_LPLL_5B_H    (REG_LPLL_BASE + 0xB7)
#define REG_LPLL_5C_L    (REG_LPLL_BASE + 0xB8)
#define REG_LPLL_5C_H    (REG_LPLL_BASE + 0xB9)
#define REG_LPLL_5D_L    (REG_LPLL_BASE + 0xBA)
#define REG_LPLL_5D_H    (REG_LPLL_BASE + 0xBB)
#define REG_LPLL_5E_L    (REG_LPLL_BASE + 0xBC)
#define REG_LPLL_5E_H    (REG_LPLL_BASE + 0xBD)
#define REG_LPLL_5F_L    (REG_LPLL_BASE + 0xBE)
#define REG_LPLL_5F_H    (REG_LPLL_BASE + 0xBF)
#define REG_LPLL_60_L    (REG_LPLL_BASE + 0xC0)
#define REG_LPLL_60_H    (REG_LPLL_BASE + 0xC1)
#define REG_LPLL_61_L    (REG_LPLL_BASE + 0xC2)
#define REG_LPLL_61_H    (REG_LPLL_BASE + 0xC3)
#define REG_LPLL_62_L    (REG_LPLL_BASE + 0xC4)
#define REG_LPLL_62_H    (REG_LPLL_BASE + 0xC5)
#define REG_LPLL_63_L    (REG_LPLL_BASE + 0xC6)
#define REG_LPLL_63_H    (REG_LPLL_BASE + 0xC7)
#define REG_LPLL_64_L    (REG_LPLL_BASE + 0xC8)
#define REG_LPLL_64_H    (REG_LPLL_BASE + 0xC9)
#define REG_LPLL_65_L    (REG_LPLL_BASE + 0xCA)
#define REG_LPLL_65_H    (REG_LPLL_BASE + 0xCB)
#define REG_LPLL_66_L    (REG_LPLL_BASE + 0xCC)
#define REG_LPLL_66_H    (REG_LPLL_BASE + 0xCD)
#define REG_LPLL_67_L    (REG_LPLL_BASE + 0xCE)
#define REG_LPLL_67_H    (REG_LPLL_BASE + 0xCF)
#define REG_LPLL_68_L    (REG_LPLL_BASE + 0xD0)
#define REG_LPLL_68_H    (REG_LPLL_BASE + 0xD1)
#define REG_LPLL_69_L    (REG_LPLL_BASE + 0xD2)
#define REG_LPLL_69_H    (REG_LPLL_BASE + 0xD3)
#define REG_LPLL_6A_L    (REG_LPLL_BASE + 0xD4)
#define REG_LPLL_6A_H    (REG_LPLL_BASE + 0xD5)
#define REG_LPLL_6B_L    (REG_LPLL_BASE + 0xD6)
#define REG_LPLL_6B_H    (REG_LPLL_BASE + 0xD7)
#define REG_LPLL_6C_L    (REG_LPLL_BASE + 0xD8)
#define REG_LPLL_6C_H    (REG_LPLL_BASE + 0xD9)
#define REG_LPLL_6D_L    (REG_LPLL_BASE + 0xDA)
#define REG_LPLL_6D_H    (REG_LPLL_BASE + 0xDB)
#define REG_LPLL_6E_L    (REG_LPLL_BASE + 0xDC)
#define REG_LPLL_6E_H    (REG_LPLL_BASE + 0xDD)
#define REG_LPLL_6F_L    (REG_LPLL_BASE + 0xDE)
#define REG_LPLL_6F_H    (REG_LPLL_BASE + 0xDF)
#define REG_LPLL_70_L    (REG_LPLL_BASE + 0xE0)
#define REG_LPLL_70_H    (REG_LPLL_BASE + 0xE1)
#define REG_LPLL_71_L    (REG_LPLL_BASE + 0xE2)
#define REG_LPLL_71_H    (REG_LPLL_BASE + 0xE3)
#define REG_LPLL_72_L    (REG_LPLL_BASE + 0xE4)
#define REG_LPLL_72_H    (REG_LPLL_BASE + 0xE5)
#define REG_LPLL_73_L    (REG_LPLL_BASE + 0xE6)
#define REG_LPLL_73_H    (REG_LPLL_BASE + 0xE7)
#define REG_LPLL_74_L    (REG_LPLL_BASE + 0xE8)
#define REG_LPLL_74_H    (REG_LPLL_BASE + 0xE9)
#define REG_LPLL_75_L    (REG_LPLL_BASE + 0xEA)
#define REG_LPLL_75_H    (REG_LPLL_BASE + 0xEB)
#define REG_LPLL_76_L    (REG_LPLL_BASE + 0xEC)
#define REG_LPLL_76_H    (REG_LPLL_BASE + 0xED)
#define REG_LPLL_77_L    (REG_LPLL_BASE + 0xEE)
#define REG_LPLL_77_H    (REG_LPLL_BASE + 0xEF)
#define REG_LPLL_78_L    (REG_LPLL_BASE + 0xF0)
#define REG_LPLL_78_H    (REG_LPLL_BASE + 0xF1)
#define REG_LPLL_79_L    (REG_LPLL_BASE + 0xF2)
#define REG_LPLL_79_H    (REG_LPLL_BASE + 0xF3)
#define REG_LPLL_7A_L    (REG_LPLL_BASE + 0xF4)
#define REG_LPLL_7A_H    (REG_LPLL_BASE + 0xF5)
#define REG_LPLL_7B_L    (REG_LPLL_BASE + 0xF6)
#define REG_LPLL_7B_H    (REG_LPLL_BASE + 0xF7)
#define REG_LPLL_7C_L    (REG_LPLL_BASE + 0xF8)
#define REG_LPLL_7C_H    (REG_LPLL_BASE + 0xF9)
#define REG_LPLL_7D_L    (REG_LPLL_BASE + 0xFA)
#define REG_LPLL_7D_H    (REG_LPLL_BASE + 0xFB)
#define REG_LPLL_7E_L    (REG_LPLL_BASE + 0xFC)
#define REG_LPLL_7E_H    (REG_LPLL_BASE + 0xFD)
#define REG_LPLL_7F_L    (REG_LPLL_BASE + 0xFE)
#define REG_LPLL_7F_H    (REG_LPLL_BASE + 0xFF)


#define REG_CLKGEN_00_L    (REG_CLKGEN_BASE + 0x00)
#define REG_CLKGEN_00_H    (REG_CLKGEN_BASE + 0x01)
#define REG_CLKGEN_01_L    (REG_CLKGEN_BASE + 0x02)
#define REG_CLKGEN_01_H    (REG_CLKGEN_BASE + 0x03)
#define REG_CLKGEN_02_L    (REG_CLKGEN_BASE + 0x04)
#define REG_CLKGEN_02_H    (REG_CLKGEN_BASE + 0x05)
#define REG_CLKGEN_03_L    (REG_CLKGEN_BASE + 0x06)
#define REG_CLKGEN_03_H    (REG_CLKGEN_BASE + 0x07)
#define REG_CLKGEN_04_L    (REG_CLKGEN_BASE + 0x08)
#define REG_CLKGEN_04_H    (REG_CLKGEN_BASE + 0x09)
#define REG_CLKGEN_05_L    (REG_CLKGEN_BASE + 0x0A)
#define REG_CLKGEN_05_H    (REG_CLKGEN_BASE + 0x0B)
#define REG_CLKGEN_06_L    (REG_CLKGEN_BASE + 0x0C)
#define REG_CLKGEN_06_H    (REG_CLKGEN_BASE + 0x0D)
#define REG_CLKGEN_07_L    (REG_CLKGEN_BASE + 0x0E)
#define REG_CLKGEN_07_H    (REG_CLKGEN_BASE + 0x0F)
#define REG_CLKGEN_08_L    (REG_CLKGEN_BASE + 0x10)
#define REG_CLKGEN_08_H    (REG_CLKGEN_BASE + 0x11)
#define REG_CLKGEN_09_L    (REG_CLKGEN_BASE + 0x12)
#define REG_CLKGEN_09_H    (REG_CLKGEN_BASE + 0x13)
#define REG_CLKGEN_0A_L    (REG_CLKGEN_BASE + 0x14)
#define REG_CLKGEN_0A_H    (REG_CLKGEN_BASE + 0x15)
#define REG_CLKGEN_0B_L    (REG_CLKGEN_BASE + 0x16)
#define REG_CLKGEN_0B_H    (REG_CLKGEN_BASE + 0x17)
#define REG_CLKGEN_0C_L    (REG_CLKGEN_BASE + 0x18)
#define REG_CLKGEN_0C_H    (REG_CLKGEN_BASE + 0x19)
#define REG_CLKGEN_0D_L    (REG_CLKGEN_BASE + 0x1A)
#define REG_CLKGEN_0D_H    (REG_CLKGEN_BASE + 0x1B)
#define REG_CLKGEN_0E_L    (REG_CLKGEN_BASE + 0x1C)
#define REG_CLKGEN_0E_H    (REG_CLKGEN_BASE + 0x1D)
#define REG_CLKGEN_0F_L    (REG_CLKGEN_BASE + 0x1E)
#define REG_CLKGEN_0F_H    (REG_CLKGEN_BASE + 0x1F)
#define REG_CLKGEN_10_L    (REG_CLKGEN_BASE + 0x20)
#define REG_CLKGEN_10_H    (REG_CLKGEN_BASE + 0x21)
#define REG_CLKGEN_11_L    (REG_CLKGEN_BASE + 0x22)
#define REG_CLKGEN_11_H    (REG_CLKGEN_BASE + 0x23)
#define REG_CLKGEN_12_L    (REG_CLKGEN_BASE + 0x24)
#define REG_CLKGEN_12_H    (REG_CLKGEN_BASE + 0x25)
#define REG_CLKGEN_13_L    (REG_CLKGEN_BASE + 0x26)
#define REG_CLKGEN_13_H    (REG_CLKGEN_BASE + 0x27)
#define REG_CLKGEN_14_L    (REG_CLKGEN_BASE + 0x28)
#define REG_CLKGEN_14_H    (REG_CLKGEN_BASE + 0x29)
#define REG_CLKGEN_15_L    (REG_CLKGEN_BASE + 0x2A)
#define REG_CLKGEN_15_H    (REG_CLKGEN_BASE + 0x2B)
#define REG_CLKGEN_16_L    (REG_CLKGEN_BASE + 0x2C)
#define REG_CLKGEN_16_H    (REG_CLKGEN_BASE + 0x2D)
#define REG_CLKGEN_17_L    (REG_CLKGEN_BASE + 0x2E)
#define REG_CLKGEN_17_H    (REG_CLKGEN_BASE + 0x2F)
#define REG_CLKGEN_18_L    (REG_CLKGEN_BASE + 0x30)
#define REG_CLKGEN_18_H    (REG_CLKGEN_BASE + 0x31)
#define REG_CLKGEN_19_L    (REG_CLKGEN_BASE + 0x32)
#define REG_CLKGEN_19_H    (REG_CLKGEN_BASE + 0x33)
#define REG_CLKGEN_1A_L    (REG_CLKGEN_BASE + 0x34)
#define REG_CLKGEN_1A_H    (REG_CLKGEN_BASE + 0x35)
#define REG_CLKGEN_1B_L    (REG_CLKGEN_BASE + 0x36)
#define REG_CLKGEN_1B_H    (REG_CLKGEN_BASE + 0x37)
#define REG_CLKGEN_1C_L    (REG_CLKGEN_BASE + 0x38)
#define REG_CLKGEN_1C_H    (REG_CLKGEN_BASE + 0x39)
#define REG_CLKGEN_1D_L    (REG_CLKGEN_BASE + 0x3A)
#define REG_CLKGEN_1D_H    (REG_CLKGEN_BASE + 0x3B)
#define REG_CLKGEN_1E_L    (REG_CLKGEN_BASE + 0x3C)
#define REG_CLKGEN_1E_H    (REG_CLKGEN_BASE + 0x3D)
#define REG_CLKGEN_1F_L    (REG_CLKGEN_BASE + 0x3E)
#define REG_CLKGEN_1F_H    (REG_CLKGEN_BASE + 0x3F)
#define REG_CLKGEN_20_L    (REG_CLKGEN_BASE + 0x40)
#define REG_CLKGEN_20_H    (REG_CLKGEN_BASE + 0x41)
#define REG_CLKGEN_21_L    (REG_CLKGEN_BASE + 0x42)
#define REG_CLKGEN_21_H    (REG_CLKGEN_BASE + 0x43)
#define REG_CLKGEN_22_L    (REG_CLKGEN_BASE + 0x44)
#define REG_CLKGEN_22_H    (REG_CLKGEN_BASE + 0x45)
#define REG_CLKGEN_23_L    (REG_CLKGEN_BASE + 0x46)
#define REG_CLKGEN_23_H    (REG_CLKGEN_BASE + 0x47)
#define REG_CLKGEN_24_L    (REG_CLKGEN_BASE + 0x48)
#define REG_CLKGEN_24_H    (REG_CLKGEN_BASE + 0x49)
#define REG_CLKGEN_25_L    (REG_CLKGEN_BASE + 0x4A)
#define REG_CLKGEN_25_H    (REG_CLKGEN_BASE + 0x4B)
#define REG_CLKGEN_26_L    (REG_CLKGEN_BASE + 0x4C)
#define REG_CLKGEN_26_H    (REG_CLKGEN_BASE + 0x4D)
#define REG_CLKGEN_27_L    (REG_CLKGEN_BASE + 0x4E)
#define REG_CLKGEN_27_H    (REG_CLKGEN_BASE + 0x4F)
#define REG_CLKGEN_28_L    (REG_CLKGEN_BASE + 0x50)
#define REG_CLKGEN_28_H    (REG_CLKGEN_BASE + 0x51)
#define REG_CLKGEN_29_L    (REG_CLKGEN_BASE + 0x52)
#define REG_CLKGEN_29_H    (REG_CLKGEN_BASE + 0x53)
#define REG_CLKGEN_2A_L    (REG_CLKGEN_BASE + 0x54)
#define REG_CLKGEN_2A_H    (REG_CLKGEN_BASE + 0x55)
#define REG_CLKGEN_2B_L    (REG_CLKGEN_BASE + 0x56)
#define REG_CLKGEN_2B_H    (REG_CLKGEN_BASE + 0x57)
#define REG_CLKGEN_2C_L    (REG_CLKGEN_BASE + 0x58)
#define REG_CLKGEN_2C_H    (REG_CLKGEN_BASE + 0x59)
#define REG_CLKGEN_2D_L    (REG_CLKGEN_BASE + 0x5A)
#define REG_CLKGEN_2D_H    (REG_CLKGEN_BASE + 0x5B)
#define REG_CLKGEN_2E_L    (REG_CLKGEN_BASE + 0x5C)
#define REG_CLKGEN_2E_H    (REG_CLKGEN_BASE + 0x5D)
#define REG_CLKGEN_2F_L    (REG_CLKGEN_BASE + 0x5E)
#define REG_CLKGEN_2F_H    (REG_CLKGEN_BASE + 0x5F)
#define REG_CLKGEN_30_L    (REG_CLKGEN_BASE + 0x60)
#define REG_CLKGEN_30_H    (REG_CLKGEN_BASE + 0x61)
#define REG_CLKGEN_31_L    (REG_CLKGEN_BASE + 0x62)
#define REG_CLKGEN_31_H    (REG_CLKGEN_BASE + 0x63)
#define REG_CLKGEN_32_L    (REG_CLKGEN_BASE + 0x64)
#define REG_CLKGEN_32_H    (REG_CLKGEN_BASE + 0x65)
#define REG_CLKGEN_33_L    (REG_CLKGEN_BASE + 0x66)
#define REG_CLKGEN_33_H    (REG_CLKGEN_BASE + 0x67)
#define REG_CLKGEN_34_L    (REG_CLKGEN_BASE + 0x68)
#define REG_CLKGEN_34_H    (REG_CLKGEN_BASE + 0x69)
#define REG_CLKGEN_35_L    (REG_CLKGEN_BASE + 0x6A)
#define REG_CLKGEN_35_H    (REG_CLKGEN_BASE + 0x6B)
#define REG_CLKGEN_36_L    (REG_CLKGEN_BASE + 0x6C)
#define REG_CLKGEN_36_H    (REG_CLKGEN_BASE + 0x6D)
#define REG_CLKGEN_37_L    (REG_CLKGEN_BASE + 0x6E)
#define REG_CLKGEN_37_H    (REG_CLKGEN_BASE + 0x6F)
#define REG_CLKGEN_38_L    (REG_CLKGEN_BASE + 0x70)
#define REG_CLKGEN_38_H    (REG_CLKGEN_BASE + 0x71)
#define REG_CLKGEN_39_L    (REG_CLKGEN_BASE + 0x72)
#define REG_CLKGEN_39_H    (REG_CLKGEN_BASE + 0x73)
#define REG_CLKGEN_3A_L    (REG_CLKGEN_BASE + 0x74)
#define REG_CLKGEN_3A_H    (REG_CLKGEN_BASE + 0x75)
#define REG_CLKGEN_3B_L    (REG_CLKGEN_BASE + 0x76)
#define REG_CLKGEN_3B_H    (REG_CLKGEN_BASE + 0x77)
#define REG_CLKGEN_3C_L    (REG_CLKGEN_BASE + 0x78)
#define REG_CLKGEN_3C_H    (REG_CLKGEN_BASE + 0x79)
#define REG_CLKGEN_3D_L    (REG_CLKGEN_BASE + 0x7A)
#define REG_CLKGEN_3D_H    (REG_CLKGEN_BASE + 0x7B)
#define REG_CLKGEN_3E_L    (REG_CLKGEN_BASE + 0x7C)
#define REG_CLKGEN_3E_H    (REG_CLKGEN_BASE + 0x7D)
#define REG_CLKGEN_3F_L    (REG_CLKGEN_BASE + 0x7E)
#define REG_CLKGEN_3F_H    (REG_CLKGEN_BASE + 0x7F)
#define REG_CLKGEN_40_L    (REG_CLKGEN_BASE + 0x80)
#define REG_CLKGEN_40_H    (REG_CLKGEN_BASE + 0x81)
#define REG_CLKGEN_41_L    (REG_CLKGEN_BASE + 0x82)
#define REG_CLKGEN_41_H    (REG_CLKGEN_BASE + 0x83)
#define REG_CLKGEN_42_L    (REG_CLKGEN_BASE + 0x84)
#define REG_CLKGEN_42_H    (REG_CLKGEN_BASE + 0x85)
#define REG_CLKGEN_43_L    (REG_CLKGEN_BASE + 0x86)
#define REG_CLKGEN_43_H    (REG_CLKGEN_BASE + 0x87)
#define REG_CLKGEN_44_L    (REG_CLKGEN_BASE + 0x88)
#define REG_CLKGEN_44_H    (REG_CLKGEN_BASE + 0x89)
#define REG_CLKGEN_45_L    (REG_CLKGEN_BASE + 0x8A)
#define REG_CLKGEN_45_H    (REG_CLKGEN_BASE + 0x8B)
#define REG_CLKGEN_46_L    (REG_CLKGEN_BASE + 0x8C)
#define REG_CLKGEN_46_H    (REG_CLKGEN_BASE + 0x8D)
#define REG_CLKGEN_47_L    (REG_CLKGEN_BASE + 0x8E)
#define REG_CLKGEN_47_H    (REG_CLKGEN_BASE + 0x8F)
#define REG_CLKGEN_48_L    (REG_CLKGEN_BASE + 0x90)
#define REG_CLKGEN_48_H    (REG_CLKGEN_BASE + 0x91)
#define REG_CLKGEN_49_L    (REG_CLKGEN_BASE + 0x92)
#define REG_CLKGEN_49_H    (REG_CLKGEN_BASE + 0x93)
#define REG_CLKGEN_4A_L    (REG_CLKGEN_BASE + 0x94)
#define REG_CLKGEN_4A_H    (REG_CLKGEN_BASE + 0x95)
#define REG_CLKGEN_4B_L    (REG_CLKGEN_BASE + 0x96)
#define REG_CLKGEN_4B_H    (REG_CLKGEN_BASE + 0x97)
#define REG_CLKGEN_4C_L    (REG_CLKGEN_BASE + 0x98)
#define REG_CLKGEN_4C_H    (REG_CLKGEN_BASE + 0x99)
#define REG_CLKGEN_4D_L    (REG_CLKGEN_BASE + 0x9A)
#define REG_CLKGEN_4D_H    (REG_CLKGEN_BASE + 0x9B)
#define REG_CLKGEN_4E_L    (REG_CLKGEN_BASE + 0x9C)
#define REG_CLKGEN_4E_H    (REG_CLKGEN_BASE + 0x9D)
#define REG_CLKGEN_4F_L    (REG_CLKGEN_BASE + 0x9E)
#define REG_CLKGEN_4F_H    (REG_CLKGEN_BASE + 0x9F)
#define REG_CLKGEN_50_L    (REG_CLKGEN_BASE + 0xA0)
#define REG_CLKGEN_50_H    (REG_CLKGEN_BASE + 0xA1)
#define REG_CLKGEN_51_L    (REG_CLKGEN_BASE + 0xA2)
#define REG_CLKGEN_51_H    (REG_CLKGEN_BASE + 0xA3)
#define REG_CLKGEN_52_L    (REG_CLKGEN_BASE + 0xA4)
#define REG_CLKGEN_52_H    (REG_CLKGEN_BASE + 0xA5)
#define REG_CLKGEN_53_L    (REG_CLKGEN_BASE + 0xA6)
#define REG_CLKGEN_53_H    (REG_CLKGEN_BASE + 0xA7)
#define REG_CLKGEN_54_L    (REG_CLKGEN_BASE + 0xA8)
#define REG_CLKGEN_54_H    (REG_CLKGEN_BASE + 0xA9)
#define REG_CLKGEN_55_L    (REG_CLKGEN_BASE + 0xAA)
#define REG_CLKGEN_55_H    (REG_CLKGEN_BASE + 0xAB)
#define REG_CLKGEN_56_L    (REG_CLKGEN_BASE + 0xAC)
#define REG_CLKGEN_56_H    (REG_CLKGEN_BASE + 0xAD)
#define REG_CLKGEN_57_L    (REG_CLKGEN_BASE + 0xAE)
#define REG_CLKGEN_57_H    (REG_CLKGEN_BASE + 0xAF)
#define REG_CLKGEN_58_L    (REG_CLKGEN_BASE + 0xB0)
#define REG_CLKGEN_58_H    (REG_CLKGEN_BASE + 0xB1)
#define REG_CLKGEN_59_L    (REG_CLKGEN_BASE + 0xB2)
#define REG_CLKGEN_59_H    (REG_CLKGEN_BASE + 0xB3)
#define REG_CLKGEN_5A_L    (REG_CLKGEN_BASE + 0xB4)
#define REG_CLKGEN_5A_H    (REG_CLKGEN_BASE + 0xB5)
#define REG_CLKGEN_5B_L    (REG_CLKGEN_BASE + 0xB6)
#define REG_CLKGEN_5B_H    (REG_CLKGEN_BASE + 0xB7)
#define REG_CLKGEN_5C_L    (REG_CLKGEN_BASE + 0xB8)
#define REG_CLKGEN_5C_H    (REG_CLKGEN_BASE + 0xB9)
#define REG_CLKGEN_5D_L    (REG_CLKGEN_BASE + 0xBA)
#define REG_CLKGEN_5D_H    (REG_CLKGEN_BASE + 0xBB)
#define REG_CLKGEN_5E_L    (REG_CLKGEN_BASE + 0xBC)
#define REG_CLKGEN_5E_H    (REG_CLKGEN_BASE + 0xBD)
#define REG_CLKGEN_5F_L    (REG_CLKGEN_BASE + 0xBE)
#define REG_CLKGEN_5F_H    (REG_CLKGEN_BASE + 0xBF)
#define REG_CLKGEN_60_L    (REG_CLKGEN_BASE + 0xC0)
#define REG_CLKGEN_60_H    (REG_CLKGEN_BASE + 0xC1)
#define REG_CLKGEN_61_L    (REG_CLKGEN_BASE + 0xC2)
#define REG_CLKGEN_61_H    (REG_CLKGEN_BASE + 0xC3)
#define REG_CLKGEN_62_L    (REG_CLKGEN_BASE + 0xC4)
#define REG_CLKGEN_62_H    (REG_CLKGEN_BASE + 0xC5)
#define REG_CLKGEN_63_L    (REG_CLKGEN_BASE + 0xC6)
#define REG_CLKGEN_63_H    (REG_CLKGEN_BASE + 0xC7)
#define REG_CLKGEN_64_L    (REG_CLKGEN_BASE + 0xC8)
#define REG_CLKGEN_64_H    (REG_CLKGEN_BASE + 0xC9)
#define REG_CLKGEN_65_L    (REG_CLKGEN_BASE + 0xCA)
#define REG_CLKGEN_65_H    (REG_CLKGEN_BASE + 0xCB)
#define REG_CLKGEN_66_L    (REG_CLKGEN_BASE + 0xCC)
#define REG_CLKGEN_66_H    (REG_CLKGEN_BASE + 0xCD)
#define REG_CLKGEN_67_L    (REG_CLKGEN_BASE + 0xCE)
#define REG_CLKGEN_67_H    (REG_CLKGEN_BASE + 0xCF)
#define REG_CLKGEN_68_L    (REG_CLKGEN_BASE + 0xD0)
#define REG_CLKGEN_68_H    (REG_CLKGEN_BASE + 0xD1)
#define REG_CLKGEN_69_L    (REG_CLKGEN_BASE + 0xD2)
#define REG_CLKGEN_69_H    (REG_CLKGEN_BASE + 0xD3)
#define REG_CLKGEN_6A_L    (REG_CLKGEN_BASE + 0xD4)
#define REG_CLKGEN_6A_H    (REG_CLKGEN_BASE + 0xD5)
#define REG_CLKGEN_6B_L    (REG_CLKGEN_BASE + 0xD6)
#define REG_CLKGEN_6B_H    (REG_CLKGEN_BASE + 0xD7)
#define REG_CLKGEN_6C_L    (REG_CLKGEN_BASE + 0xD8)
#define REG_CLKGEN_6C_H    (REG_CLKGEN_BASE + 0xD9)
#define REG_CLKGEN_6D_L    (REG_CLKGEN_BASE + 0xDA)
#define REG_CLKGEN_6D_H    (REG_CLKGEN_BASE + 0xDB)
#define REG_CLKGEN_6E_L    (REG_CLKGEN_BASE + 0xDC)
#define REG_CLKGEN_6E_H    (REG_CLKGEN_BASE + 0xDD)
#define REG_CLKGEN_6F_L    (REG_CLKGEN_BASE + 0xDE)
#define REG_CLKGEN_6F_H    (REG_CLKGEN_BASE + 0xDF)
#define REG_CLKGEN_70_L    (REG_CLKGEN_BASE + 0xE0)
#define REG_CLKGEN_70_H    (REG_CLKGEN_BASE + 0xE1)
#define REG_CLKGEN_71_L    (REG_CLKGEN_BASE + 0xE2)
#define REG_CLKGEN_71_H    (REG_CLKGEN_BASE + 0xE3)
#define REG_CLKGEN_72_L    (REG_CLKGEN_BASE + 0xE4)
#define REG_CLKGEN_72_H    (REG_CLKGEN_BASE + 0xE5)
#define REG_CLKGEN_73_L    (REG_CLKGEN_BASE + 0xE6)
#define REG_CLKGEN_73_H    (REG_CLKGEN_BASE + 0xE7)
#define REG_CLKGEN_74_L    (REG_CLKGEN_BASE + 0xE8)
#define REG_CLKGEN_74_H    (REG_CLKGEN_BASE + 0xE9)
#define REG_CLKGEN_75_L    (REG_CLKGEN_BASE + 0xEA)
#define REG_CLKGEN_75_H    (REG_CLKGEN_BASE + 0xEB)
#define REG_CLKGEN_76_L    (REG_CLKGEN_BASE + 0xEC)
#define REG_CLKGEN_76_H    (REG_CLKGEN_BASE + 0xED)
#define REG_CLKGEN_77_L    (REG_CLKGEN_BASE + 0xEE)
#define REG_CLKGEN_77_H    (REG_CLKGEN_BASE + 0xEF)
#define REG_CLKGEN_78_L    (REG_CLKGEN_BASE + 0xF0)
#define REG_CLKGEN_78_H    (REG_CLKGEN_BASE + 0xF1)
#define REG_CLKGEN_79_L    (REG_CLKGEN_BASE + 0xF2)
#define REG_CLKGEN_79_H    (REG_CLKGEN_BASE + 0xF3)
#define REG_CLKGEN_7A_L    (REG_CLKGEN_BASE + 0xF4)
#define REG_CLKGEN_7A_H    (REG_CLKGEN_BASE + 0xF5)
#define REG_CLKGEN_7B_L    (REG_CLKGEN_BASE + 0xF6)
#define REG_CLKGEN_7B_H    (REG_CLKGEN_BASE + 0xF7)
#define REG_CLKGEN_7C_L    (REG_CLKGEN_BASE + 0xF8)
#define REG_CLKGEN_7C_H    (REG_CLKGEN_BASE + 0xF9)
#define REG_CLKGEN_7D_L    (REG_CLKGEN_BASE + 0xFA)
#define REG_CLKGEN_7D_H    (REG_CLKGEN_BASE + 0xFB)
#define REG_CLKGEN_7E_L    (REG_CLKGEN_BASE + 0xFC)
#define REG_CLKGEN_7E_H    (REG_CLKGEN_BASE + 0xFD)
#define REG_CLKGEN_7F_L    (REG_CLKGEN_BASE + 0xFE)
#define REG_CLKGEN_7F_H    (REG_CLKGEN_BASE + 0xFF)

#define REG_SC_CTRL_00_L    (REG_SC_CTRL_BASE + 0x00)
#define REG_SC_CTRL_00_H    (REG_SC_CTRL_BASE + 0x01)
#define REG_SC_CTRL_01_L    (REG_SC_CTRL_BASE + 0x02)
#define REG_SC_CTRL_01_H    (REG_SC_CTRL_BASE + 0x03)
#define REG_SC_CTRL_02_L    (REG_SC_CTRL_BASE + 0x04)
#define REG_SC_CTRL_02_H    (REG_SC_CTRL_BASE + 0x05)
#define REG_SC_CTRL_03_L    (REG_SC_CTRL_BASE + 0x06)
#define REG_SC_CTRL_03_H    (REG_SC_CTRL_BASE + 0x07)
#define REG_SC_CTRL_04_L    (REG_SC_CTRL_BASE + 0x08)
#define REG_SC_CTRL_04_H    (REG_SC_CTRL_BASE + 0x09)
#define REG_SC_CTRL_05_L    (REG_SC_CTRL_BASE + 0x0A)
#define REG_SC_CTRL_05_H    (REG_SC_CTRL_BASE + 0x0B)
#define REG_SC_CTRL_06_L    (REG_SC_CTRL_BASE + 0x0C)
#define REG_SC_CTRL_06_H    (REG_SC_CTRL_BASE + 0x0D)
#define REG_SC_CTRL_07_L    (REG_SC_CTRL_BASE + 0x0E)
#define REG_SC_CTRL_07_H    (REG_SC_CTRL_BASE + 0x0F)
#define REG_SC_CTRL_08_L    (REG_SC_CTRL_BASE + 0x10)
#define REG_SC_CTRL_08_H    (REG_SC_CTRL_BASE + 0x11)
#define REG_SC_CTRL_09_L    (REG_SC_CTRL_BASE + 0x12)
#define REG_SC_CTRL_09_H    (REG_SC_CTRL_BASE + 0x13)
#define REG_SC_CTRL_0A_L    (REG_SC_CTRL_BASE + 0x14)
#define REG_SC_CTRL_0A_H    (REG_SC_CTRL_BASE + 0x15)
#define REG_SC_CTRL_0B_L    (REG_SC_CTRL_BASE + 0x16)
#define REG_SC_CTRL_0B_H    (REG_SC_CTRL_BASE + 0x17)
#define REG_SC_CTRL_0C_L    (REG_SC_CTRL_BASE + 0x18)
#define REG_SC_CTRL_0C_H    (REG_SC_CTRL_BASE + 0x19)
#define REG_SC_CTRL_0D_L    (REG_SC_CTRL_BASE + 0x1A)
#define REG_SC_CTRL_0D_H    (REG_SC_CTRL_BASE + 0x1B)
#define REG_SC_CTRL_0E_L    (REG_SC_CTRL_BASE + 0x1C)
#define REG_SC_CTRL_0E_H    (REG_SC_CTRL_BASE + 0x1D)
#define REG_SC_CTRL_0F_L    (REG_SC_CTRL_BASE + 0x1E)
#define REG_SC_CTRL_0F_H    (REG_SC_CTRL_BASE + 0x1F)
#define REG_SC_CTRL_10_L    (REG_SC_CTRL_BASE + 0x20)
#define REG_SC_CTRL_10_H    (REG_SC_CTRL_BASE + 0x21)
#define REG_SC_CTRL_11_L    (REG_SC_CTRL_BASE + 0x22)
#define REG_SC_CTRL_11_H    (REG_SC_CTRL_BASE + 0x23)
#define REG_SC_CTRL_12_L    (REG_SC_CTRL_BASE + 0x24)
#define REG_SC_CTRL_12_H    (REG_SC_CTRL_BASE + 0x25)
#define REG_SC_CTRL_13_L    (REG_SC_CTRL_BASE + 0x26)
#define REG_SC_CTRL_13_H    (REG_SC_CTRL_BASE + 0x27)
#define REG_SC_CTRL_14_L    (REG_SC_CTRL_BASE + 0x28)
#define REG_SC_CTRL_14_H    (REG_SC_CTRL_BASE + 0x29)
#define REG_SC_CTRL_15_L    (REG_SC_CTRL_BASE + 0x2A)
#define REG_SC_CTRL_15_H    (REG_SC_CTRL_BASE + 0x2B)
#define REG_SC_CTRL_16_L    (REG_SC_CTRL_BASE + 0x2C)
#define REG_SC_CTRL_16_H    (REG_SC_CTRL_BASE + 0x2D)
#define REG_SC_CTRL_17_L    (REG_SC_CTRL_BASE + 0x2E)
#define REG_SC_CTRL_17_H    (REG_SC_CTRL_BASE + 0x2F)
#define REG_SC_CTRL_18_L    (REG_SC_CTRL_BASE + 0x30)
#define REG_SC_CTRL_18_H    (REG_SC_CTRL_BASE + 0x31)
#define REG_SC_CTRL_19_L    (REG_SC_CTRL_BASE + 0x32)
#define REG_SC_CTRL_19_H    (REG_SC_CTRL_BASE + 0x33)
#define REG_SC_CTRL_1A_L    (REG_SC_CTRL_BASE + 0x34)
#define REG_SC_CTRL_1A_H    (REG_SC_CTRL_BASE + 0x35)
#define REG_SC_CTRL_1B_L    (REG_SC_CTRL_BASE + 0x36)
#define REG_SC_CTRL_1B_H    (REG_SC_CTRL_BASE + 0x37)
#define REG_SC_CTRL_1C_L    (REG_SC_CTRL_BASE + 0x38)
#define REG_SC_CTRL_1C_H    (REG_SC_CTRL_BASE + 0x39)
#define REG_SC_CTRL_1D_L    (REG_SC_CTRL_BASE + 0x3A)
#define REG_SC_CTRL_1D_H    (REG_SC_CTRL_BASE + 0x3B)
#define REG_SC_CTRL_1E_L    (REG_SC_CTRL_BASE + 0x3C)
#define REG_SC_CTRL_1E_H    (REG_SC_CTRL_BASE + 0x3D)
#define REG_SC_CTRL_1F_L    (REG_SC_CTRL_BASE + 0x3E)
#define REG_SC_CTRL_1F_H    (REG_SC_CTRL_BASE + 0x3F)
#define REG_SC_CTRL_20_L    (REG_SC_CTRL_BASE + 0x40)
#define REG_SC_CTRL_20_H    (REG_SC_CTRL_BASE + 0x41)
#define REG_SC_CTRL_21_L    (REG_SC_CTRL_BASE + 0x42)
#define REG_SC_CTRL_21_H    (REG_SC_CTRL_BASE + 0x43)
#define REG_SC_CTRL_22_L    (REG_SC_CTRL_BASE + 0x44)
#define REG_SC_CTRL_22_H    (REG_SC_CTRL_BASE + 0x45)
#define REG_SC_CTRL_23_L    (REG_SC_CTRL_BASE + 0x46)
#define REG_SC_CTRL_23_H    (REG_SC_CTRL_BASE + 0x47)
#define REG_SC_CTRL_24_L    (REG_SC_CTRL_BASE + 0x48)
#define REG_SC_CTRL_24_H    (REG_SC_CTRL_BASE + 0x49)
#define REG_SC_CTRL_25_L    (REG_SC_CTRL_BASE + 0x4A)
#define REG_SC_CTRL_25_H    (REG_SC_CTRL_BASE + 0x4B)
#define REG_SC_CTRL_26_L    (REG_SC_CTRL_BASE + 0x4C)
#define REG_SC_CTRL_26_H    (REG_SC_CTRL_BASE + 0x4D)
#define REG_SC_CTRL_27_L    (REG_SC_CTRL_BASE + 0x4E)
#define REG_SC_CTRL_27_H    (REG_SC_CTRL_BASE + 0x4F)
#define REG_SC_CTRL_28_L    (REG_SC_CTRL_BASE + 0x50)
#define REG_SC_CTRL_28_H    (REG_SC_CTRL_BASE + 0x51)
#define REG_SC_CTRL_29_L    (REG_SC_CTRL_BASE + 0x52)
#define REG_SC_CTRL_29_H    (REG_SC_CTRL_BASE + 0x53)
#define REG_SC_CTRL_2A_L    (REG_SC_CTRL_BASE + 0x54)
#define REG_SC_CTRL_2A_H    (REG_SC_CTRL_BASE + 0x55)
#define REG_SC_CTRL_2B_L    (REG_SC_CTRL_BASE + 0x56)
#define REG_SC_CTRL_2B_H    (REG_SC_CTRL_BASE + 0x57)
#define REG_SC_CTRL_2C_L    (REG_SC_CTRL_BASE + 0x58)
#define REG_SC_CTRL_2C_H    (REG_SC_CTRL_BASE + 0x59)
#define REG_SC_CTRL_2D_L    (REG_SC_CTRL_BASE + 0x5A)
#define REG_SC_CTRL_2D_H    (REG_SC_CTRL_BASE + 0x5B)
#define REG_SC_CTRL_2E_L    (REG_SC_CTRL_BASE + 0x5C)
#define REG_SC_CTRL_2E_H    (REG_SC_CTRL_BASE + 0x5D)
#define REG_SC_CTRL_2F_L    (REG_SC_CTRL_BASE + 0x5E)
#define REG_SC_CTRL_2F_H    (REG_SC_CTRL_BASE + 0x5F)
#define REG_SC_CTRL_30_L    (REG_SC_CTRL_BASE + 0x60)
#define REG_SC_CTRL_30_H    (REG_SC_CTRL_BASE + 0x61)
#define REG_SC_CTRL_31_L    (REG_SC_CTRL_BASE + 0x62)
#define REG_SC_CTRL_31_H    (REG_SC_CTRL_BASE + 0x63)
#define REG_SC_CTRL_32_L    (REG_SC_CTRL_BASE + 0x64)
#define REG_SC_CTRL_32_H    (REG_SC_CTRL_BASE + 0x65)
#define REG_SC_CTRL_33_L    (REG_SC_CTRL_BASE + 0x66)
#define REG_SC_CTRL_33_H    (REG_SC_CTRL_BASE + 0x67)
#define REG_SC_CTRL_34_L    (REG_SC_CTRL_BASE + 0x68)
#define REG_SC_CTRL_34_H    (REG_SC_CTRL_BASE + 0x69)
#define REG_SC_CTRL_35_L    (REG_SC_CTRL_BASE + 0x6A)
#define REG_SC_CTRL_35_H    (REG_SC_CTRL_BASE + 0x6B)
#define REG_SC_CTRL_36_L    (REG_SC_CTRL_BASE + 0x6C)
#define REG_SC_CTRL_36_H    (REG_SC_CTRL_BASE + 0x6D)
#define REG_SC_CTRL_37_L    (REG_SC_CTRL_BASE + 0x6E)
#define REG_SC_CTRL_37_H    (REG_SC_CTRL_BASE + 0x6F)
#define REG_SC_CTRL_38_L    (REG_SC_CTRL_BASE + 0x70)
#define REG_SC_CTRL_38_H    (REG_SC_CTRL_BASE + 0x71)
#define REG_SC_CTRL_39_L    (REG_SC_CTRL_BASE + 0x72)
#define REG_SC_CTRL_39_H    (REG_SC_CTRL_BASE + 0x73)
#define REG_SC_CTRL_3A_L    (REG_SC_CTRL_BASE + 0x74)
#define REG_SC_CTRL_3A_H    (REG_SC_CTRL_BASE + 0x75)
#define REG_SC_CTRL_3B_L    (REG_SC_CTRL_BASE + 0x76)
#define REG_SC_CTRL_3B_H    (REG_SC_CTRL_BASE + 0x77)
#define REG_SC_CTRL_3C_L    (REG_SC_CTRL_BASE + 0x78)
#define REG_SC_CTRL_3C_H    (REG_SC_CTRL_BASE + 0x79)
#define REG_SC_CTRL_3D_L    (REG_SC_CTRL_BASE + 0x7A)
#define REG_SC_CTRL_3D_H    (REG_SC_CTRL_BASE + 0x7B)
#define REG_SC_CTRL_3E_L    (REG_SC_CTRL_BASE + 0x7C)
#define REG_SC_CTRL_3E_H    (REG_SC_CTRL_BASE + 0x7D)
#define REG_SC_CTRL_3F_L    (REG_SC_CTRL_BASE + 0x7E)
#define REG_SC_CTRL_3F_H    (REG_SC_CTRL_BASE + 0x7F)
#define REG_SC_CTRL_40_L    (REG_SC_CTRL_BASE + 0x80)
#define REG_SC_CTRL_40_H    (REG_SC_CTRL_BASE + 0x81)
#define REG_SC_CTRL_41_L    (REG_SC_CTRL_BASE + 0x82)
#define REG_SC_CTRL_41_H    (REG_SC_CTRL_BASE + 0x83)
#define REG_SC_CTRL_42_L    (REG_SC_CTRL_BASE + 0x84)
#define REG_SC_CTRL_42_H    (REG_SC_CTRL_BASE + 0x85)
#define REG_SC_CTRL_43_L    (REG_SC_CTRL_BASE + 0x86)
#define REG_SC_CTRL_43_H    (REG_SC_CTRL_BASE + 0x87)
#define REG_SC_CTRL_44_L    (REG_SC_CTRL_BASE + 0x88)
#define REG_SC_CTRL_44_H    (REG_SC_CTRL_BASE + 0x89)
#define REG_SC_CTRL_45_L    (REG_SC_CTRL_BASE + 0x8A)
#define REG_SC_CTRL_45_H    (REG_SC_CTRL_BASE + 0x8B)
#define REG_SC_CTRL_46_L    (REG_SC_CTRL_BASE + 0x8C)
#define REG_SC_CTRL_46_H    (REG_SC_CTRL_BASE + 0x8D)
#define REG_SC_CTRL_47_L    (REG_SC_CTRL_BASE + 0x8E)
#define REG_SC_CTRL_47_H    (REG_SC_CTRL_BASE + 0x8F)
#define REG_SC_CTRL_48_L    (REG_SC_CTRL_BASE + 0x90)
#define REG_SC_CTRL_48_H    (REG_SC_CTRL_BASE + 0x91)
#define REG_SC_CTRL_49_L    (REG_SC_CTRL_BASE + 0x92)
#define REG_SC_CTRL_49_H    (REG_SC_CTRL_BASE + 0x93)
#define REG_SC_CTRL_4A_L    (REG_SC_CTRL_BASE + 0x94)
#define REG_SC_CTRL_4A_H    (REG_SC_CTRL_BASE + 0x95)
#define REG_SC_CTRL_4B_L    (REG_SC_CTRL_BASE + 0x96)
#define REG_SC_CTRL_4B_H    (REG_SC_CTRL_BASE + 0x97)
#define REG_SC_CTRL_4C_L    (REG_SC_CTRL_BASE + 0x98)
#define REG_SC_CTRL_4C_H    (REG_SC_CTRL_BASE + 0x99)
#define REG_SC_CTRL_4D_L    (REG_SC_CTRL_BASE + 0x9A)
#define REG_SC_CTRL_4D_H    (REG_SC_CTRL_BASE + 0x9B)
#define REG_SC_CTRL_4E_L    (REG_SC_CTRL_BASE + 0x9C)
#define REG_SC_CTRL_4E_H    (REG_SC_CTRL_BASE + 0x9D)
#define REG_SC_CTRL_4F_L    (REG_SC_CTRL_BASE + 0x9E)
#define REG_SC_CTRL_4F_H    (REG_SC_CTRL_BASE + 0x9F)
#define REG_SC_CTRL_50_L    (REG_SC_CTRL_BASE + 0xA0)
#define REG_SC_CTRL_50_H    (REG_SC_CTRL_BASE + 0xA1)
#define REG_SC_CTRL_51_L    (REG_SC_CTRL_BASE + 0xA2)
#define REG_SC_CTRL_51_H    (REG_SC_CTRL_BASE + 0xA3)
#define REG_SC_CTRL_52_L    (REG_SC_CTRL_BASE + 0xA4)
#define REG_SC_CTRL_52_H    (REG_SC_CTRL_BASE + 0xA5)
#define REG_SC_CTRL_53_L    (REG_SC_CTRL_BASE + 0xA6)
#define REG_SC_CTRL_53_H    (REG_SC_CTRL_BASE + 0xA7)
#define REG_SC_CTRL_54_L    (REG_SC_CTRL_BASE + 0xA8)
#define REG_SC_CTRL_54_H    (REG_SC_CTRL_BASE + 0xA9)
#define REG_SC_CTRL_55_L    (REG_SC_CTRL_BASE + 0xAA)
#define REG_SC_CTRL_55_H    (REG_SC_CTRL_BASE + 0xAB)
#define REG_SC_CTRL_56_L    (REG_SC_CTRL_BASE + 0xAC)
#define REG_SC_CTRL_56_H    (REG_SC_CTRL_BASE + 0xAD)
#define REG_SC_CTRL_57_L    (REG_SC_CTRL_BASE + 0xAE)
#define REG_SC_CTRL_57_H    (REG_SC_CTRL_BASE + 0xAF)
#define REG_SC_CTRL_58_L    (REG_SC_CTRL_BASE + 0xB0)
#define REG_SC_CTRL_58_H    (REG_SC_CTRL_BASE + 0xB1)
#define REG_SC_CTRL_59_L    (REG_SC_CTRL_BASE + 0xB2)
#define REG_SC_CTRL_59_H    (REG_SC_CTRL_BASE + 0xB3)
#define REG_SC_CTRL_5A_L    (REG_SC_CTRL_BASE + 0xB4)
#define REG_SC_CTRL_5A_H    (REG_SC_CTRL_BASE + 0xB5)
#define REG_SC_CTRL_5B_L    (REG_SC_CTRL_BASE + 0xB6)
#define REG_SC_CTRL_5B_H    (REG_SC_CTRL_BASE + 0xB7)
#define REG_SC_CTRL_5C_L    (REG_SC_CTRL_BASE + 0xB8)
#define REG_SC_CTRL_5C_H    (REG_SC_CTRL_BASE + 0xB9)
#define REG_SC_CTRL_5D_L    (REG_SC_CTRL_BASE + 0xBA)
#define REG_SC_CTRL_5D_H    (REG_SC_CTRL_BASE + 0xBB)
#define REG_SC_CTRL_5E_L    (REG_SC_CTRL_BASE + 0xBC)
#define REG_SC_CTRL_5E_H    (REG_SC_CTRL_BASE + 0xBD)
#define REG_SC_CTRL_5F_L    (REG_SC_CTRL_BASE + 0xBE)
#define REG_SC_CTRL_5F_H    (REG_SC_CTRL_BASE + 0xBF)
#define REG_SC_CTRL_60_L    (REG_SC_CTRL_BASE + 0xC0)
#define REG_SC_CTRL_60_H    (REG_SC_CTRL_BASE + 0xC1)
#define REG_SC_CTRL_61_L    (REG_SC_CTRL_BASE + 0xC2)
#define REG_SC_CTRL_61_H    (REG_SC_CTRL_BASE + 0xC3)
#define REG_SC_CTRL_62_L    (REG_SC_CTRL_BASE + 0xC4)
#define REG_SC_CTRL_62_H    (REG_SC_CTRL_BASE + 0xC5)
#define REG_SC_CTRL_63_L    (REG_SC_CTRL_BASE + 0xC6)
#define REG_SC_CTRL_63_H    (REG_SC_CTRL_BASE + 0xC7)
#define REG_SC_CTRL_64_L    (REG_SC_CTRL_BASE + 0xC8)
#define REG_SC_CTRL_64_H    (REG_SC_CTRL_BASE + 0xC9)
#define REG_SC_CTRL_65_L    (REG_SC_CTRL_BASE + 0xCA)
#define REG_SC_CTRL_65_H    (REG_SC_CTRL_BASE + 0xCB)
#define REG_SC_CTRL_66_L    (REG_SC_CTRL_BASE + 0xCC)
#define REG_SC_CTRL_66_H    (REG_SC_CTRL_BASE + 0xCD)
#define REG_SC_CTRL_67_L    (REG_SC_CTRL_BASE + 0xCE)
#define REG_SC_CTRL_67_H    (REG_SC_CTRL_BASE + 0xCF)
#define REG_SC_CTRL_68_L    (REG_SC_CTRL_BASE + 0xD0)
#define REG_SC_CTRL_68_H    (REG_SC_CTRL_BASE + 0xD1)
#define REG_SC_CTRL_69_L    (REG_SC_CTRL_BASE + 0xD2)
#define REG_SC_CTRL_69_H    (REG_SC_CTRL_BASE + 0xD3)
#define REG_SC_CTRL_6A_L    (REG_SC_CTRL_BASE + 0xD4)
#define REG_SC_CTRL_6A_H    (REG_SC_CTRL_BASE + 0xD5)
#define REG_SC_CTRL_6B_L    (REG_SC_CTRL_BASE + 0xD6)
#define REG_SC_CTRL_6B_H    (REG_SC_CTRL_BASE + 0xD7)
#define REG_SC_CTRL_6C_L    (REG_SC_CTRL_BASE + 0xD8)
#define REG_SC_CTRL_6C_H    (REG_SC_CTRL_BASE + 0xD9)
#define REG_SC_CTRL_6D_L    (REG_SC_CTRL_BASE + 0xDA)
#define REG_SC_CTRL_6D_H    (REG_SC_CTRL_BASE + 0xDB)
#define REG_SC_CTRL_6E_L    (REG_SC_CTRL_BASE + 0xDC)
#define REG_SC_CTRL_6E_H    (REG_SC_CTRL_BASE + 0xDD)
#define REG_SC_CTRL_6F_L    (REG_SC_CTRL_BASE + 0xDE)
#define REG_SC_CTRL_6F_H    (REG_SC_CTRL_BASE + 0xDF)
#define REG_SC_CTRL_70_L    (REG_SC_CTRL_BASE + 0xE0)
#define REG_SC_CTRL_70_H    (REG_SC_CTRL_BASE + 0xE1)
#define REG_SC_CTRL_71_L    (REG_SC_CTRL_BASE + 0xE2)
#define REG_SC_CTRL_71_H    (REG_SC_CTRL_BASE + 0xE3)
#define REG_SC_CTRL_72_L    (REG_SC_CTRL_BASE + 0xE4)
#define REG_SC_CTRL_72_H    (REG_SC_CTRL_BASE + 0xE5)
#define REG_SC_CTRL_73_L    (REG_SC_CTRL_BASE + 0xE6)
#define REG_SC_CTRL_73_H    (REG_SC_CTRL_BASE + 0xE7)
#define REG_SC_CTRL_74_L    (REG_SC_CTRL_BASE + 0xE8)
#define REG_SC_CTRL_74_H    (REG_SC_CTRL_BASE + 0xE9)
#define REG_SC_CTRL_75_L    (REG_SC_CTRL_BASE + 0xEA)
#define REG_SC_CTRL_75_H    (REG_SC_CTRL_BASE + 0xEB)
#define REG_SC_CTRL_76_L    (REG_SC_CTRL_BASE + 0xEC)
#define REG_SC_CTRL_76_H    (REG_SC_CTRL_BASE + 0xED)
#define REG_SC_CTRL_77_L    (REG_SC_CTRL_BASE + 0xEE)
#define REG_SC_CTRL_77_H    (REG_SC_CTRL_BASE + 0xEF)
#define REG_SC_CTRL_78_L    (REG_SC_CTRL_BASE + 0xF0)
#define REG_SC_CTRL_78_H    (REG_SC_CTRL_BASE + 0xF1)
#define REG_SC_CTRL_79_L    (REG_SC_CTRL_BASE + 0xF2)
#define REG_SC_CTRL_79_H    (REG_SC_CTRL_BASE + 0xF3)
#define REG_SC_CTRL_7A_L    (REG_SC_CTRL_BASE + 0xF4)
#define REG_SC_CTRL_7A_H    (REG_SC_CTRL_BASE + 0xF5)
#define REG_SC_CTRL_7B_L    (REG_SC_CTRL_BASE + 0xF6)
#define REG_SC_CTRL_7B_H    (REG_SC_CTRL_BASE + 0xF7)
#define REG_SC_CTRL_7C_L    (REG_SC_CTRL_BASE + 0xF8)
#define REG_SC_CTRL_7C_H    (REG_SC_CTRL_BASE + 0xF9)
#define REG_SC_CTRL_7D_L    (REG_SC_CTRL_BASE + 0xFA)
#define REG_SC_CTRL_7D_H    (REG_SC_CTRL_BASE + 0xFB)
#define REG_SC_CTRL_7E_L    (REG_SC_CTRL_BASE + 0xFC)
#define REG_SC_CTRL_7E_H    (REG_SC_CTRL_BASE + 0xFD)
#define REG_SC_CTRL_7F_L    (REG_SC_CTRL_BASE + 0xFE)
#define REG_SC_CTRL_7F_H    (REG_SC_CTRL_BASE + 0xFF)

#define REG_DISP_TOP_00_L    (REG_DISP_TOP_BASE + 0x00)
#define REG_DISP_TOP_00_H    (REG_DISP_TOP_BASE + 0x01)
#define REG_DISP_TOP_01_L    (REG_DISP_TOP_BASE + 0x02)
#define REG_DISP_TOP_01_H    (REG_DISP_TOP_BASE + 0x03)
#define REG_DISP_TOP_02_L    (REG_DISP_TOP_BASE + 0x04)
#define REG_DISP_TOP_02_H    (REG_DISP_TOP_BASE + 0x05)
#define REG_DISP_TOP_03_L    (REG_DISP_TOP_BASE + 0x06)
#define REG_DISP_TOP_03_H    (REG_DISP_TOP_BASE + 0x07)
#define REG_DISP_TOP_04_L    (REG_DISP_TOP_BASE + 0x08)
#define REG_DISP_TOP_04_H    (REG_DISP_TOP_BASE + 0x09)
#define REG_DISP_TOP_05_L    (REG_DISP_TOP_BASE + 0x0A)
#define REG_DISP_TOP_05_H    (REG_DISP_TOP_BASE + 0x0B)
#define REG_DISP_TOP_06_L    (REG_DISP_TOP_BASE + 0x0C)
#define REG_DISP_TOP_06_H    (REG_DISP_TOP_BASE + 0x0D)
#define REG_DISP_TOP_07_L    (REG_DISP_TOP_BASE + 0x0E)
#define REG_DISP_TOP_07_H    (REG_DISP_TOP_BASE + 0x0F)
#define REG_DISP_TOP_08_L    (REG_DISP_TOP_BASE + 0x10)
#define REG_DISP_TOP_08_H    (REG_DISP_TOP_BASE + 0x11)
#define REG_DISP_TOP_09_L    (REG_DISP_TOP_BASE + 0x12)
#define REG_DISP_TOP_09_H    (REG_DISP_TOP_BASE + 0x13)
#define REG_DISP_TOP_0A_L    (REG_DISP_TOP_BASE + 0x14)
#define REG_DISP_TOP_0A_H    (REG_DISP_TOP_BASE + 0x15)
#define REG_DISP_TOP_0B_L    (REG_DISP_TOP_BASE + 0x16)
#define REG_DISP_TOP_0B_H    (REG_DISP_TOP_BASE + 0x17)
#define REG_DISP_TOP_0C_L    (REG_DISP_TOP_BASE + 0x18)
#define REG_DISP_TOP_0C_H    (REG_DISP_TOP_BASE + 0x19)
#define REG_DISP_TOP_0D_L    (REG_DISP_TOP_BASE + 0x1A)
#define REG_DISP_TOP_0D_H    (REG_DISP_TOP_BASE + 0x1B)
#define REG_DISP_TOP_0E_L    (REG_DISP_TOP_BASE + 0x1C)
#define REG_DISP_TOP_0E_H    (REG_DISP_TOP_BASE + 0x1D)
#define REG_DISP_TOP_0F_L    (REG_DISP_TOP_BASE + 0x1E)
#define REG_DISP_TOP_0F_H    (REG_DISP_TOP_BASE + 0x1F)
#define REG_DISP_TOP_10_L    (REG_DISP_TOP_BASE + 0x20)
#define REG_DISP_TOP_10_H    (REG_DISP_TOP_BASE + 0x21)
#define REG_DISP_TOP_11_L    (REG_DISP_TOP_BASE + 0x22)
#define REG_DISP_TOP_11_H    (REG_DISP_TOP_BASE + 0x23)
#define REG_DISP_TOP_12_L    (REG_DISP_TOP_BASE + 0x24)
#define REG_DISP_TOP_12_H    (REG_DISP_TOP_BASE + 0x25)
#define REG_DISP_TOP_13_L    (REG_DISP_TOP_BASE + 0x26)
#define REG_DISP_TOP_13_H    (REG_DISP_TOP_BASE + 0x27)
#define REG_DISP_TOP_14_L    (REG_DISP_TOP_BASE + 0x28)
#define REG_DISP_TOP_14_H    (REG_DISP_TOP_BASE + 0x29)
#define REG_DISP_TOP_15_L    (REG_DISP_TOP_BASE + 0x2A)
#define REG_DISP_TOP_15_H    (REG_DISP_TOP_BASE + 0x2B)
#define REG_DISP_TOP_16_L    (REG_DISP_TOP_BASE + 0x2C)
#define REG_DISP_TOP_16_H    (REG_DISP_TOP_BASE + 0x2D)
#define REG_DISP_TOP_17_L    (REG_DISP_TOP_BASE + 0x2E)
#define REG_DISP_TOP_17_H    (REG_DISP_TOP_BASE + 0x2F)
#define REG_DISP_TOP_18_L    (REG_DISP_TOP_BASE + 0x30)
#define REG_DISP_TOP_18_H    (REG_DISP_TOP_BASE + 0x31)
#define REG_DISP_TOP_19_L    (REG_DISP_TOP_BASE + 0x32)
#define REG_DISP_TOP_19_H    (REG_DISP_TOP_BASE + 0x33)
#define REG_DISP_TOP_1A_L    (REG_DISP_TOP_BASE + 0x34)
#define REG_DISP_TOP_1A_H    (REG_DISP_TOP_BASE + 0x35)
#define REG_DISP_TOP_1B_L    (REG_DISP_TOP_BASE + 0x36)
#define REG_DISP_TOP_1B_H    (REG_DISP_TOP_BASE + 0x37)
#define REG_DISP_TOP_1C_L    (REG_DISP_TOP_BASE + 0x38)
#define REG_DISP_TOP_1C_H    (REG_DISP_TOP_BASE + 0x39)
#define REG_DISP_TOP_1D_L    (REG_DISP_TOP_BASE + 0x3A)
#define REG_DISP_TOP_1D_H    (REG_DISP_TOP_BASE + 0x3B)
#define REG_DISP_TOP_1E_L    (REG_DISP_TOP_BASE + 0x3C)
#define REG_DISP_TOP_1E_H    (REG_DISP_TOP_BASE + 0x3D)
#define REG_DISP_TOP_1F_L    (REG_DISP_TOP_BASE + 0x3E)
#define REG_DISP_TOP_1F_H    (REG_DISP_TOP_BASE + 0x3F)
#define REG_DISP_TOP_20_L    (REG_DISP_TOP_BASE + 0x40)
#define REG_DISP_TOP_20_H    (REG_DISP_TOP_BASE + 0x41)
#define REG_DISP_TOP_21_L    (REG_DISP_TOP_BASE + 0x42)
#define REG_DISP_TOP_21_H    (REG_DISP_TOP_BASE + 0x43)
#define REG_DISP_TOP_22_L    (REG_DISP_TOP_BASE + 0x44)
#define REG_DISP_TOP_22_H    (REG_DISP_TOP_BASE + 0x45)
#define REG_DISP_TOP_23_L    (REG_DISP_TOP_BASE + 0x46)
#define REG_DISP_TOP_23_H    (REG_DISP_TOP_BASE + 0x47)
#define REG_DISP_TOP_24_L    (REG_DISP_TOP_BASE + 0x48)
#define REG_DISP_TOP_24_H    (REG_DISP_TOP_BASE + 0x49)
#define REG_DISP_TOP_25_L    (REG_DISP_TOP_BASE + 0x4A)
#define REG_DISP_TOP_25_H    (REG_DISP_TOP_BASE + 0x4B)
#define REG_DISP_TOP_26_L    (REG_DISP_TOP_BASE + 0x4C)
#define REG_DISP_TOP_26_H    (REG_DISP_TOP_BASE + 0x4D)
#define REG_DISP_TOP_27_L    (REG_DISP_TOP_BASE + 0x4E)
#define REG_DISP_TOP_27_H    (REG_DISP_TOP_BASE + 0x4F)
#define REG_DISP_TOP_28_L    (REG_DISP_TOP_BASE + 0x50)
#define REG_DISP_TOP_28_H    (REG_DISP_TOP_BASE + 0x51)
#define REG_DISP_TOP_29_L    (REG_DISP_TOP_BASE + 0x52)
#define REG_DISP_TOP_29_H    (REG_DISP_TOP_BASE + 0x53)
#define REG_DISP_TOP_2A_L    (REG_DISP_TOP_BASE + 0x54)
#define REG_DISP_TOP_2A_H    (REG_DISP_TOP_BASE + 0x55)
#define REG_DISP_TOP_2B_L    (REG_DISP_TOP_BASE + 0x56)
#define REG_DISP_TOP_2B_H    (REG_DISP_TOP_BASE + 0x57)
#define REG_DISP_TOP_2C_L    (REG_DISP_TOP_BASE + 0x58)
#define REG_DISP_TOP_2C_H    (REG_DISP_TOP_BASE + 0x59)
#define REG_DISP_TOP_2D_L    (REG_DISP_TOP_BASE + 0x5A)
#define REG_DISP_TOP_2D_H    (REG_DISP_TOP_BASE + 0x5B)
#define REG_DISP_TOP_2E_L    (REG_DISP_TOP_BASE + 0x5C)
#define REG_DISP_TOP_2E_H    (REG_DISP_TOP_BASE + 0x5D)
#define REG_DISP_TOP_2F_L    (REG_DISP_TOP_BASE + 0x5E)
#define REG_DISP_TOP_2F_H    (REG_DISP_TOP_BASE + 0x5F)
#define REG_DISP_TOP_30_L    (REG_DISP_TOP_BASE + 0x60)
#define REG_DISP_TOP_30_H    (REG_DISP_TOP_BASE + 0x61)
#define REG_DISP_TOP_31_L    (REG_DISP_TOP_BASE + 0x62)
#define REG_DISP_TOP_31_H    (REG_DISP_TOP_BASE + 0x63)
#define REG_DISP_TOP_32_L    (REG_DISP_TOP_BASE + 0x64)
#define REG_DISP_TOP_32_H    (REG_DISP_TOP_BASE + 0x65)
#define REG_DISP_TOP_33_L    (REG_DISP_TOP_BASE + 0x66)
#define REG_DISP_TOP_33_H    (REG_DISP_TOP_BASE + 0x67)
#define REG_DISP_TOP_34_L    (REG_DISP_TOP_BASE + 0x68)
#define REG_DISP_TOP_34_H    (REG_DISP_TOP_BASE + 0x69)
#define REG_DISP_TOP_35_L    (REG_DISP_TOP_BASE + 0x6A)
#define REG_DISP_TOP_35_H    (REG_DISP_TOP_BASE + 0x6B)
#define REG_DISP_TOP_36_L    (REG_DISP_TOP_BASE + 0x6C)
#define REG_DISP_TOP_36_H    (REG_DISP_TOP_BASE + 0x6D)
#define REG_DISP_TOP_37_L    (REG_DISP_TOP_BASE + 0x6E)
#define REG_DISP_TOP_37_H    (REG_DISP_TOP_BASE + 0x6F)
#define REG_DISP_TOP_38_L    (REG_DISP_TOP_BASE + 0x70)
#define REG_DISP_TOP_38_H    (REG_DISP_TOP_BASE + 0x71)
#define REG_DISP_TOP_39_L    (REG_DISP_TOP_BASE + 0x72)
#define REG_DISP_TOP_39_H    (REG_DISP_TOP_BASE + 0x73)
#define REG_DISP_TOP_3A_L    (REG_DISP_TOP_BASE + 0x74)
#define REG_DISP_TOP_3A_H    (REG_DISP_TOP_BASE + 0x75)
#define REG_DISP_TOP_3B_L    (REG_DISP_TOP_BASE + 0x76)
#define REG_DISP_TOP_3B_H    (REG_DISP_TOP_BASE + 0x77)
#define REG_DISP_TOP_3C_L    (REG_DISP_TOP_BASE + 0x78)
#define REG_DISP_TOP_3C_H    (REG_DISP_TOP_BASE + 0x79)
#define REG_DISP_TOP_3D_L    (REG_DISP_TOP_BASE + 0x7A)
#define REG_DISP_TOP_3D_H    (REG_DISP_TOP_BASE + 0x7B)
#define REG_DISP_TOP_3E_L    (REG_DISP_TOP_BASE + 0x7C)
#define REG_DISP_TOP_3E_H    (REG_DISP_TOP_BASE + 0x7D)
#define REG_DISP_TOP_3F_L    (REG_DISP_TOP_BASE + 0x7E)
#define REG_DISP_TOP_3F_H    (REG_DISP_TOP_BASE + 0x7F)
#define REG_DISP_TOP_40_L    (REG_DISP_TOP_BASE + 0x80)
#define REG_DISP_TOP_40_H    (REG_DISP_TOP_BASE + 0x81)
#define REG_DISP_TOP_41_L    (REG_DISP_TOP_BASE + 0x82)
#define REG_DISP_TOP_41_H    (REG_DISP_TOP_BASE + 0x83)
#define REG_DISP_TOP_42_L    (REG_DISP_TOP_BASE + 0x84)
#define REG_DISP_TOP_42_H    (REG_DISP_TOP_BASE + 0x85)
#define REG_DISP_TOP_43_L    (REG_DISP_TOP_BASE + 0x86)
#define REG_DISP_TOP_43_H    (REG_DISP_TOP_BASE + 0x87)
#define REG_DISP_TOP_44_L    (REG_DISP_TOP_BASE + 0x88)
#define REG_DISP_TOP_44_H    (REG_DISP_TOP_BASE + 0x89)
#define REG_DISP_TOP_45_L    (REG_DISP_TOP_BASE + 0x8A)
#define REG_DISP_TOP_45_H    (REG_DISP_TOP_BASE + 0x8B)
#define REG_DISP_TOP_46_L    (REG_DISP_TOP_BASE + 0x8C)
#define REG_DISP_TOP_46_H    (REG_DISP_TOP_BASE + 0x8D)
#define REG_DISP_TOP_47_L    (REG_DISP_TOP_BASE + 0x8E)
#define REG_DISP_TOP_47_H    (REG_DISP_TOP_BASE + 0x8F)
#define REG_DISP_TOP_48_L    (REG_DISP_TOP_BASE + 0x90)
#define REG_DISP_TOP_48_H    (REG_DISP_TOP_BASE + 0x91)
#define REG_DISP_TOP_49_L    (REG_DISP_TOP_BASE + 0x92)
#define REG_DISP_TOP_49_H    (REG_DISP_TOP_BASE + 0x93)
#define REG_DISP_TOP_4A_L    (REG_DISP_TOP_BASE + 0x94)
#define REG_DISP_TOP_4A_H    (REG_DISP_TOP_BASE + 0x95)
#define REG_DISP_TOP_4B_L    (REG_DISP_TOP_BASE + 0x96)
#define REG_DISP_TOP_4B_H    (REG_DISP_TOP_BASE + 0x97)
#define REG_DISP_TOP_4C_L    (REG_DISP_TOP_BASE + 0x98)
#define REG_DISP_TOP_4C_H    (REG_DISP_TOP_BASE + 0x99)
#define REG_DISP_TOP_4D_L    (REG_DISP_TOP_BASE + 0x9A)
#define REG_DISP_TOP_4D_H    (REG_DISP_TOP_BASE + 0x9B)
#define REG_DISP_TOP_4E_L    (REG_DISP_TOP_BASE + 0x9C)
#define REG_DISP_TOP_4E_H    (REG_DISP_TOP_BASE + 0x9D)
#define REG_DISP_TOP_4F_L    (REG_DISP_TOP_BASE + 0x9E)
#define REG_DISP_TOP_4F_H    (REG_DISP_TOP_BASE + 0x9F)
#define REG_DISP_TOP_50_L    (REG_DISP_TOP_BASE + 0xA0)
#define REG_DISP_TOP_50_H    (REG_DISP_TOP_BASE + 0xA1)
#define REG_DISP_TOP_51_L    (REG_DISP_TOP_BASE + 0xA2)
#define REG_DISP_TOP_51_H    (REG_DISP_TOP_BASE + 0xA3)
#define REG_DISP_TOP_52_L    (REG_DISP_TOP_BASE + 0xA4)
#define REG_DISP_TOP_52_H    (REG_DISP_TOP_BASE + 0xA5)
#define REG_DISP_TOP_53_L    (REG_DISP_TOP_BASE + 0xA6)
#define REG_DISP_TOP_53_H    (REG_DISP_TOP_BASE + 0xA7)
#define REG_DISP_TOP_54_L    (REG_DISP_TOP_BASE + 0xA8)
#define REG_DISP_TOP_54_H    (REG_DISP_TOP_BASE + 0xA9)
#define REG_DISP_TOP_55_L    (REG_DISP_TOP_BASE + 0xAA)
#define REG_DISP_TOP_55_H    (REG_DISP_TOP_BASE + 0xAB)
#define REG_DISP_TOP_56_L    (REG_DISP_TOP_BASE + 0xAC)
#define REG_DISP_TOP_56_H    (REG_DISP_TOP_BASE + 0xAD)
#define REG_DISP_TOP_57_L    (REG_DISP_TOP_BASE + 0xAE)
#define REG_DISP_TOP_57_H    (REG_DISP_TOP_BASE + 0xAF)
#define REG_DISP_TOP_58_L    (REG_DISP_TOP_BASE + 0xB0)
#define REG_DISP_TOP_58_H    (REG_DISP_TOP_BASE + 0xB1)
#define REG_DISP_TOP_59_L    (REG_DISP_TOP_BASE + 0xB2)
#define REG_DISP_TOP_59_H    (REG_DISP_TOP_BASE + 0xB3)
#define REG_DISP_TOP_5A_L    (REG_DISP_TOP_BASE + 0xB4)
#define REG_DISP_TOP_5A_H    (REG_DISP_TOP_BASE + 0xB5)
#define REG_DISP_TOP_5B_L    (REG_DISP_TOP_BASE + 0xB6)
#define REG_DISP_TOP_5B_H    (REG_DISP_TOP_BASE + 0xB7)
#define REG_DISP_TOP_5C_L    (REG_DISP_TOP_BASE + 0xB8)
#define REG_DISP_TOP_5C_H    (REG_DISP_TOP_BASE + 0xB9)
#define REG_DISP_TOP_5D_L    (REG_DISP_TOP_BASE + 0xBA)
#define REG_DISP_TOP_5D_H    (REG_DISP_TOP_BASE + 0xBB)
#define REG_DISP_TOP_5E_L    (REG_DISP_TOP_BASE + 0xBC)
#define REG_DISP_TOP_5E_H    (REG_DISP_TOP_BASE + 0xBD)
#define REG_DISP_TOP_5F_L    (REG_DISP_TOP_BASE + 0xBE)
#define REG_DISP_TOP_5F_H    (REG_DISP_TOP_BASE + 0xBF)
#define REG_DISP_TOP_60_L    (REG_DISP_TOP_BASE + 0xC0)
#define REG_DISP_TOP_60_H    (REG_DISP_TOP_BASE + 0xC1)
#define REG_DISP_TOP_61_L    (REG_DISP_TOP_BASE + 0xC2)
#define REG_DISP_TOP_61_H    (REG_DISP_TOP_BASE + 0xC3)
#define REG_DISP_TOP_62_L    (REG_DISP_TOP_BASE + 0xC4)
#define REG_DISP_TOP_62_H    (REG_DISP_TOP_BASE + 0xC5)
#define REG_DISP_TOP_63_L    (REG_DISP_TOP_BASE + 0xC6)
#define REG_DISP_TOP_63_H    (REG_DISP_TOP_BASE + 0xC7)
#define REG_DISP_TOP_64_L    (REG_DISP_TOP_BASE + 0xC8)
#define REG_DISP_TOP_64_H    (REG_DISP_TOP_BASE + 0xC9)
#define REG_DISP_TOP_65_L    (REG_DISP_TOP_BASE + 0xCA)
#define REG_DISP_TOP_65_H    (REG_DISP_TOP_BASE + 0xCB)
#define REG_DISP_TOP_66_L    (REG_DISP_TOP_BASE + 0xCC)
#define REG_DISP_TOP_66_H    (REG_DISP_TOP_BASE + 0xCD)
#define REG_DISP_TOP_67_L    (REG_DISP_TOP_BASE + 0xCE)
#define REG_DISP_TOP_67_H    (REG_DISP_TOP_BASE + 0xCF)
#define REG_DISP_TOP_68_L    (REG_DISP_TOP_BASE + 0xD0)
#define REG_DISP_TOP_68_H    (REG_DISP_TOP_BASE + 0xD1)
#define REG_DISP_TOP_69_L    (REG_DISP_TOP_BASE + 0xD2)
#define REG_DISP_TOP_69_H    (REG_DISP_TOP_BASE + 0xD3)
#define REG_DISP_TOP_6A_L    (REG_DISP_TOP_BASE + 0xD4)
#define REG_DISP_TOP_6A_H    (REG_DISP_TOP_BASE + 0xD5)
#define REG_DISP_TOP_6B_L    (REG_DISP_TOP_BASE + 0xD6)
#define REG_DISP_TOP_6B_H    (REG_DISP_TOP_BASE + 0xD7)
#define REG_DISP_TOP_6C_L    (REG_DISP_TOP_BASE + 0xD8)
#define REG_DISP_TOP_6C_H    (REG_DISP_TOP_BASE + 0xD9)
#define REG_DISP_TOP_6D_L    (REG_DISP_TOP_BASE + 0xDA)
#define REG_DISP_TOP_6D_H    (REG_DISP_TOP_BASE + 0xDB)
#define REG_DISP_TOP_6E_L    (REG_DISP_TOP_BASE + 0xDC)
#define REG_DISP_TOP_6E_H    (REG_DISP_TOP_BASE + 0xDD)
#define REG_DISP_TOP_6F_L    (REG_DISP_TOP_BASE + 0xDE)
#define REG_DISP_TOP_6F_H    (REG_DISP_TOP_BASE + 0xDF)
#define REG_DISP_TOP_70_L    (REG_DISP_TOP_BASE + 0xE0)
#define REG_DISP_TOP_70_H    (REG_DISP_TOP_BASE + 0xE1)
#define REG_DISP_TOP_71_L    (REG_DISP_TOP_BASE + 0xE2)
#define REG_DISP_TOP_71_H    (REG_DISP_TOP_BASE + 0xE3)
#define REG_DISP_TOP_72_L    (REG_DISP_TOP_BASE + 0xE4)
#define REG_DISP_TOP_72_H    (REG_DISP_TOP_BASE + 0xE5)
#define REG_DISP_TOP_73_L    (REG_DISP_TOP_BASE + 0xE6)
#define REG_DISP_TOP_73_H    (REG_DISP_TOP_BASE + 0xE7)
#define REG_DISP_TOP_74_L    (REG_DISP_TOP_BASE + 0xE8)
#define REG_DISP_TOP_74_H    (REG_DISP_TOP_BASE + 0xE9)
#define REG_DISP_TOP_75_L    (REG_DISP_TOP_BASE + 0xEA)
#define REG_DISP_TOP_75_H    (REG_DISP_TOP_BASE + 0xEB)
#define REG_DISP_TOP_76_L    (REG_DISP_TOP_BASE + 0xEC)
#define REG_DISP_TOP_76_H    (REG_DISP_TOP_BASE + 0xED)
#define REG_DISP_TOP_77_L    (REG_DISP_TOP_BASE + 0xEE)
#define REG_DISP_TOP_77_H    (REG_DISP_TOP_BASE + 0xEF)
#define REG_DISP_TOP_78_L    (REG_DISP_TOP_BASE + 0xF0)
#define REG_DISP_TOP_78_H    (REG_DISP_TOP_BASE + 0xF1)
#define REG_DISP_TOP_79_L    (REG_DISP_TOP_BASE + 0xF2)
#define REG_DISP_TOP_79_H    (REG_DISP_TOP_BASE + 0xF3)
#define REG_DISP_TOP_7A_L    (REG_DISP_TOP_BASE + 0xF4)
#define REG_DISP_TOP_7A_H    (REG_DISP_TOP_BASE + 0xF5)
#define REG_DISP_TOP_7B_L    (REG_DISP_TOP_BASE + 0xF6)
#define REG_DISP_TOP_7B_H    (REG_DISP_TOP_BASE + 0xF7)
#define REG_DISP_TOP_7C_L    (REG_DISP_TOP_BASE + 0xF8)
#define REG_DISP_TOP_7C_H    (REG_DISP_TOP_BASE + 0xF9)
#define REG_DISP_TOP_7D_L    (REG_DISP_TOP_BASE + 0xFA)
#define REG_DISP_TOP_7D_H    (REG_DISP_TOP_BASE + 0xFB)
#define REG_DISP_TOP_7E_L    (REG_DISP_TOP_BASE + 0xFC)
#define REG_DISP_TOP_7E_H    (REG_DISP_TOP_BASE + 0xFD)
#define REG_DISP_TOP_7F_L    (REG_DISP_TOP_BASE + 0xFE)
#define REG_DISP_TOP_7F_H    (REG_DISP_TOP_BASE + 0xFF)



#define REG_DISP_TOP_OP2_00_L    (REG_DISP_TOP_OP2_BASE + 0x00)
#define REG_DISP_TOP_OP2_00_H    (REG_DISP_TOP_OP2_BASE + 0x01)
#define REG_DISP_TOP_OP2_01_L    (REG_DISP_TOP_OP2_BASE + 0x02)
#define REG_DISP_TOP_OP2_01_H    (REG_DISP_TOP_OP2_BASE + 0x03)
#define REG_DISP_TOP_OP2_02_L    (REG_DISP_TOP_OP2_BASE + 0x04)
#define REG_DISP_TOP_OP2_02_H    (REG_DISP_TOP_OP2_BASE + 0x05)
#define REG_DISP_TOP_OP2_03_L    (REG_DISP_TOP_OP2_BASE + 0x06)
#define REG_DISP_TOP_OP2_03_H    (REG_DISP_TOP_OP2_BASE + 0x07)
#define REG_DISP_TOP_OP2_04_L    (REG_DISP_TOP_OP2_BASE + 0x08)
#define REG_DISP_TOP_OP2_04_H    (REG_DISP_TOP_OP2_BASE + 0x09)
#define REG_DISP_TOP_OP2_05_L    (REG_DISP_TOP_OP2_BASE + 0x0A)
#define REG_DISP_TOP_OP2_05_H    (REG_DISP_TOP_OP2_BASE + 0x0B)
#define REG_DISP_TOP_OP2_06_L    (REG_DISP_TOP_OP2_BASE + 0x0C)
#define REG_DISP_TOP_OP2_06_H    (REG_DISP_TOP_OP2_BASE + 0x0D)
#define REG_DISP_TOP_OP2_07_L    (REG_DISP_TOP_OP2_BASE + 0x0E)
#define REG_DISP_TOP_OP2_07_H    (REG_DISP_TOP_OP2_BASE + 0x0F)
#define REG_DISP_TOP_OP2_08_L    (REG_DISP_TOP_OP2_BASE + 0x10)
#define REG_DISP_TOP_OP2_08_H    (REG_DISP_TOP_OP2_BASE + 0x11)
#define REG_DISP_TOP_OP2_09_L    (REG_DISP_TOP_OP2_BASE + 0x12)
#define REG_DISP_TOP_OP2_09_H    (REG_DISP_TOP_OP2_BASE + 0x13)
#define REG_DISP_TOP_OP2_0A_L    (REG_DISP_TOP_OP2_BASE + 0x14)
#define REG_DISP_TOP_OP2_0A_H    (REG_DISP_TOP_OP2_BASE + 0x15)
#define REG_DISP_TOP_OP2_0B_L    (REG_DISP_TOP_OP2_BASE + 0x16)
#define REG_DISP_TOP_OP2_0B_H    (REG_DISP_TOP_OP2_BASE + 0x17)
#define REG_DISP_TOP_OP2_0C_L    (REG_DISP_TOP_OP2_BASE + 0x18)
#define REG_DISP_TOP_OP2_0C_H    (REG_DISP_TOP_OP2_BASE + 0x19)
#define REG_DISP_TOP_OP2_0D_L    (REG_DISP_TOP_OP2_BASE + 0x1A)
#define REG_DISP_TOP_OP2_0D_H    (REG_DISP_TOP_OP2_BASE + 0x1B)
#define REG_DISP_TOP_OP2_0E_L    (REG_DISP_TOP_OP2_BASE + 0x1C)
#define REG_DISP_TOP_OP2_0E_H    (REG_DISP_TOP_OP2_BASE + 0x1D)
#define REG_DISP_TOP_OP2_0F_L    (REG_DISP_TOP_OP2_BASE + 0x1E)
#define REG_DISP_TOP_OP2_0F_H    (REG_DISP_TOP_OP2_BASE + 0x1F)
#define REG_DISP_TOP_OP2_10_L    (REG_DISP_TOP_OP2_BASE + 0x20)
#define REG_DISP_TOP_OP2_10_H    (REG_DISP_TOP_OP2_BASE + 0x21)
#define REG_DISP_TOP_OP2_11_L    (REG_DISP_TOP_OP2_BASE + 0x22)
#define REG_DISP_TOP_OP2_11_H    (REG_DISP_TOP_OP2_BASE + 0x23)
#define REG_DISP_TOP_OP2_12_L    (REG_DISP_TOP_OP2_BASE + 0x24)
#define REG_DISP_TOP_OP2_12_H    (REG_DISP_TOP_OP2_BASE + 0x25)
#define REG_DISP_TOP_OP2_13_L    (REG_DISP_TOP_OP2_BASE + 0x26)
#define REG_DISP_TOP_OP2_13_H    (REG_DISP_TOP_OP2_BASE + 0x27)
#define REG_DISP_TOP_OP2_14_L    (REG_DISP_TOP_OP2_BASE + 0x28)
#define REG_DISP_TOP_OP2_14_H    (REG_DISP_TOP_OP2_BASE + 0x29)
#define REG_DISP_TOP_OP2_15_L    (REG_DISP_TOP_OP2_BASE + 0x2A)
#define REG_DISP_TOP_OP2_15_H    (REG_DISP_TOP_OP2_BASE + 0x2B)
#define REG_DISP_TOP_OP2_16_L    (REG_DISP_TOP_OP2_BASE + 0x2C)
#define REG_DISP_TOP_OP2_16_H    (REG_DISP_TOP_OP2_BASE + 0x2D)
#define REG_DISP_TOP_OP2_17_L    (REG_DISP_TOP_OP2_BASE + 0x2E)
#define REG_DISP_TOP_OP2_17_H    (REG_DISP_TOP_OP2_BASE + 0x2F)
#define REG_DISP_TOP_OP2_18_L    (REG_DISP_TOP_OP2_BASE + 0x30)
#define REG_DISP_TOP_OP2_18_H    (REG_DISP_TOP_OP2_BASE + 0x31)
#define REG_DISP_TOP_OP2_19_L    (REG_DISP_TOP_OP2_BASE + 0x32)
#define REG_DISP_TOP_OP2_19_H    (REG_DISP_TOP_OP2_BASE + 0x33)
#define REG_DISP_TOP_OP2_1A_L    (REG_DISP_TOP_OP2_BASE + 0x34)
#define REG_DISP_TOP_OP2_1A_H    (REG_DISP_TOP_OP2_BASE + 0x35)
#define REG_DISP_TOP_OP2_1B_L    (REG_DISP_TOP_OP2_BASE + 0x36)
#define REG_DISP_TOP_OP2_1B_H    (REG_DISP_TOP_OP2_BASE + 0x37)
#define REG_DISP_TOP_OP2_1C_L    (REG_DISP_TOP_OP2_BASE + 0x38)
#define REG_DISP_TOP_OP2_1C_H    (REG_DISP_TOP_OP2_BASE + 0x39)
#define REG_DISP_TOP_OP2_1D_L    (REG_DISP_TOP_OP2_BASE + 0x3A)
#define REG_DISP_TOP_OP2_1D_H    (REG_DISP_TOP_OP2_BASE + 0x3B)
#define REG_DISP_TOP_OP2_1E_L    (REG_DISP_TOP_OP2_BASE + 0x3C)
#define REG_DISP_TOP_OP2_1E_H    (REG_DISP_TOP_OP2_BASE + 0x3D)
#define REG_DISP_TOP_OP2_1F_L    (REG_DISP_TOP_OP2_BASE + 0x3E)
#define REG_DISP_TOP_OP2_1F_H    (REG_DISP_TOP_OP2_BASE + 0x3F)
#define REG_DISP_TOP_OP2_20_L    (REG_DISP_TOP_OP2_BASE + 0x40)
#define REG_DISP_TOP_OP2_20_H    (REG_DISP_TOP_OP2_BASE + 0x41)
#define REG_DISP_TOP_OP2_21_L    (REG_DISP_TOP_OP2_BASE + 0x42)
#define REG_DISP_TOP_OP2_21_H    (REG_DISP_TOP_OP2_BASE + 0x43)
#define REG_DISP_TOP_OP2_22_L    (REG_DISP_TOP_OP2_BASE + 0x44)
#define REG_DISP_TOP_OP2_22_H    (REG_DISP_TOP_OP2_BASE + 0x45)
#define REG_DISP_TOP_OP2_23_L    (REG_DISP_TOP_OP2_BASE + 0x46)
#define REG_DISP_TOP_OP2_23_H    (REG_DISP_TOP_OP2_BASE + 0x47)
#define REG_DISP_TOP_OP2_24_L    (REG_DISP_TOP_OP2_BASE + 0x48)
#define REG_DISP_TOP_OP2_24_H    (REG_DISP_TOP_OP2_BASE + 0x49)
#define REG_DISP_TOP_OP2_25_L    (REG_DISP_TOP_OP2_BASE + 0x4A)
#define REG_DISP_TOP_OP2_25_H    (REG_DISP_TOP_OP2_BASE + 0x4B)
#define REG_DISP_TOP_OP2_26_L    (REG_DISP_TOP_OP2_BASE + 0x4C)
#define REG_DISP_TOP_OP2_26_H    (REG_DISP_TOP_OP2_BASE + 0x4D)
#define REG_DISP_TOP_OP2_27_L    (REG_DISP_TOP_OP2_BASE + 0x4E)
#define REG_DISP_TOP_OP2_27_H    (REG_DISP_TOP_OP2_BASE + 0x4F)
#define REG_DISP_TOP_OP2_28_L    (REG_DISP_TOP_OP2_BASE + 0x50)
#define REG_DISP_TOP_OP2_28_H    (REG_DISP_TOP_OP2_BASE + 0x51)
#define REG_DISP_TOP_OP2_29_L    (REG_DISP_TOP_OP2_BASE + 0x52)
#define REG_DISP_TOP_OP2_29_H    (REG_DISP_TOP_OP2_BASE + 0x53)
#define REG_DISP_TOP_OP2_2A_L    (REG_DISP_TOP_OP2_BASE + 0x54)
#define REG_DISP_TOP_OP2_2A_H    (REG_DISP_TOP_OP2_BASE + 0x55)
#define REG_DISP_TOP_OP2_2B_L    (REG_DISP_TOP_OP2_BASE + 0x56)
#define REG_DISP_TOP_OP2_2B_H    (REG_DISP_TOP_OP2_BASE + 0x57)
#define REG_DISP_TOP_OP2_2C_L    (REG_DISP_TOP_OP2_BASE + 0x58)
#define REG_DISP_TOP_OP2_2C_H    (REG_DISP_TOP_OP2_BASE + 0x59)
#define REG_DISP_TOP_OP2_2D_L    (REG_DISP_TOP_OP2_BASE + 0x5A)
#define REG_DISP_TOP_OP2_2D_H    (REG_DISP_TOP_OP2_BASE + 0x5B)
#define REG_DISP_TOP_OP2_2E_L    (REG_DISP_TOP_OP2_BASE + 0x5C)
#define REG_DISP_TOP_OP2_2E_H    (REG_DISP_TOP_OP2_BASE + 0x5D)
#define REG_DISP_TOP_OP2_2F_L    (REG_DISP_TOP_OP2_BASE + 0x5E)
#define REG_DISP_TOP_OP2_2F_H    (REG_DISP_TOP_OP2_BASE + 0x5F)
#define REG_DISP_TOP_OP2_30_L    (REG_DISP_TOP_OP2_BASE + 0x60)
#define REG_DISP_TOP_OP2_30_H    (REG_DISP_TOP_OP2_BASE + 0x61)
#define REG_DISP_TOP_OP2_31_L    (REG_DISP_TOP_OP2_BASE + 0x62)
#define REG_DISP_TOP_OP2_31_H    (REG_DISP_TOP_OP2_BASE + 0x63)
#define REG_DISP_TOP_OP2_32_L    (REG_DISP_TOP_OP2_BASE + 0x64)
#define REG_DISP_TOP_OP2_32_H    (REG_DISP_TOP_OP2_BASE + 0x65)
#define REG_DISP_TOP_OP2_33_L    (REG_DISP_TOP_OP2_BASE + 0x66)
#define REG_DISP_TOP_OP2_33_H    (REG_DISP_TOP_OP2_BASE + 0x67)
#define REG_DISP_TOP_OP2_34_L    (REG_DISP_TOP_OP2_BASE + 0x68)
#define REG_DISP_TOP_OP2_34_H    (REG_DISP_TOP_OP2_BASE + 0x69)
#define REG_DISP_TOP_OP2_35_L    (REG_DISP_TOP_OP2_BASE + 0x6A)
#define REG_DISP_TOP_OP2_35_H    (REG_DISP_TOP_OP2_BASE + 0x6B)
#define REG_DISP_TOP_OP2_36_L    (REG_DISP_TOP_OP2_BASE + 0x6C)
#define REG_DISP_TOP_OP2_36_H    (REG_DISP_TOP_OP2_BASE + 0x6D)
#define REG_DISP_TOP_OP2_37_L    (REG_DISP_TOP_OP2_BASE + 0x6E)
#define REG_DISP_TOP_OP2_37_H    (REG_DISP_TOP_OP2_BASE + 0x6F)
#define REG_DISP_TOP_OP2_38_L    (REG_DISP_TOP_OP2_BASE + 0x70)
#define REG_DISP_TOP_OP2_38_H    (REG_DISP_TOP_OP2_BASE + 0x71)
#define REG_DISP_TOP_OP2_39_L    (REG_DISP_TOP_OP2_BASE + 0x72)
#define REG_DISP_TOP_OP2_39_H    (REG_DISP_TOP_OP2_BASE + 0x73)
#define REG_DISP_TOP_OP2_3A_L    (REG_DISP_TOP_OP2_BASE + 0x74)
#define REG_DISP_TOP_OP2_3A_H    (REG_DISP_TOP_OP2_BASE + 0x75)
#define REG_DISP_TOP_OP2_3B_L    (REG_DISP_TOP_OP2_BASE + 0x76)
#define REG_DISP_TOP_OP2_3B_H    (REG_DISP_TOP_OP2_BASE + 0x77)
#define REG_DISP_TOP_OP2_3C_L    (REG_DISP_TOP_OP2_BASE + 0x78)
#define REG_DISP_TOP_OP2_3C_H    (REG_DISP_TOP_OP2_BASE + 0x79)
#define REG_DISP_TOP_OP2_3D_L    (REG_DISP_TOP_OP2_BASE + 0x7A)
#define REG_DISP_TOP_OP2_3D_H    (REG_DISP_TOP_OP2_BASE + 0x7B)
#define REG_DISP_TOP_OP2_3E_L    (REG_DISP_TOP_OP2_BASE + 0x7C)
#define REG_DISP_TOP_OP2_3E_H    (REG_DISP_TOP_OP2_BASE + 0x7D)
#define REG_DISP_TOP_OP2_3F_L    (REG_DISP_TOP_OP2_BASE + 0x7E)
#define REG_DISP_TOP_OP2_3F_H    (REG_DISP_TOP_OP2_BASE + 0x7F)
#define REG_DISP_TOP_OP2_40_L    (REG_DISP_TOP_OP2_BASE + 0x80)
#define REG_DISP_TOP_OP2_40_H    (REG_DISP_TOP_OP2_BASE + 0x81)
#define REG_DISP_TOP_OP2_41_L    (REG_DISP_TOP_OP2_BASE + 0x82)
#define REG_DISP_TOP_OP2_41_H    (REG_DISP_TOP_OP2_BASE + 0x83)
#define REG_DISP_TOP_OP2_42_L    (REG_DISP_TOP_OP2_BASE + 0x84)
#define REG_DISP_TOP_OP2_42_H    (REG_DISP_TOP_OP2_BASE + 0x85)
#define REG_DISP_TOP_OP2_43_L    (REG_DISP_TOP_OP2_BASE + 0x86)
#define REG_DISP_TOP_OP2_43_H    (REG_DISP_TOP_OP2_BASE + 0x87)
#define REG_DISP_TOP_OP2_44_L    (REG_DISP_TOP_OP2_BASE + 0x88)
#define REG_DISP_TOP_OP2_44_H    (REG_DISP_TOP_OP2_BASE + 0x89)
#define REG_DISP_TOP_OP2_45_L    (REG_DISP_TOP_OP2_BASE + 0x8A)
#define REG_DISP_TOP_OP2_45_H    (REG_DISP_TOP_OP2_BASE + 0x8B)
#define REG_DISP_TOP_OP2_46_L    (REG_DISP_TOP_OP2_BASE + 0x8C)
#define REG_DISP_TOP_OP2_46_H    (REG_DISP_TOP_OP2_BASE + 0x8D)
#define REG_DISP_TOP_OP2_47_L    (REG_DISP_TOP_OP2_BASE + 0x8E)
#define REG_DISP_TOP_OP2_47_H    (REG_DISP_TOP_OP2_BASE + 0x8F)
#define REG_DISP_TOP_OP2_48_L    (REG_DISP_TOP_OP2_BASE + 0x90)
#define REG_DISP_TOP_OP2_48_H    (REG_DISP_TOP_OP2_BASE + 0x91)
#define REG_DISP_TOP_OP2_49_L    (REG_DISP_TOP_OP2_BASE + 0x92)
#define REG_DISP_TOP_OP2_49_H    (REG_DISP_TOP_OP2_BASE + 0x93)
#define REG_DISP_TOP_OP2_4A_L    (REG_DISP_TOP_OP2_BASE + 0x94)
#define REG_DISP_TOP_OP2_4A_H    (REG_DISP_TOP_OP2_BASE + 0x95)
#define REG_DISP_TOP_OP2_4B_L    (REG_DISP_TOP_OP2_BASE + 0x96)
#define REG_DISP_TOP_OP2_4B_H    (REG_DISP_TOP_OP2_BASE + 0x97)
#define REG_DISP_TOP_OP2_4C_L    (REG_DISP_TOP_OP2_BASE + 0x98)
#define REG_DISP_TOP_OP2_4C_H    (REG_DISP_TOP_OP2_BASE + 0x99)
#define REG_DISP_TOP_OP2_4D_L    (REG_DISP_TOP_OP2_BASE + 0x9A)
#define REG_DISP_TOP_OP2_4D_H    (REG_DISP_TOP_OP2_BASE + 0x9B)
#define REG_DISP_TOP_OP2_4E_L    (REG_DISP_TOP_OP2_BASE + 0x9C)
#define REG_DISP_TOP_OP2_4E_H    (REG_DISP_TOP_OP2_BASE + 0x9D)
#define REG_DISP_TOP_OP2_4F_L    (REG_DISP_TOP_OP2_BASE + 0x9E)
#define REG_DISP_TOP_OP2_4F_H    (REG_DISP_TOP_OP2_BASE + 0x9F)
#define REG_DISP_TOP_OP2_50_L    (REG_DISP_TOP_OP2_BASE + 0xA0)
#define REG_DISP_TOP_OP2_50_H    (REG_DISP_TOP_OP2_BASE + 0xA1)
#define REG_DISP_TOP_OP2_51_L    (REG_DISP_TOP_OP2_BASE + 0xA2)
#define REG_DISP_TOP_OP2_51_H    (REG_DISP_TOP_OP2_BASE + 0xA3)
#define REG_DISP_TOP_OP2_52_L    (REG_DISP_TOP_OP2_BASE + 0xA4)
#define REG_DISP_TOP_OP2_52_H    (REG_DISP_TOP_OP2_BASE + 0xA5)
#define REG_DISP_TOP_OP2_53_L    (REG_DISP_TOP_OP2_BASE + 0xA6)
#define REG_DISP_TOP_OP2_53_H    (REG_DISP_TOP_OP2_BASE + 0xA7)
#define REG_DISP_TOP_OP2_54_L    (REG_DISP_TOP_OP2_BASE + 0xA8)
#define REG_DISP_TOP_OP2_54_H    (REG_DISP_TOP_OP2_BASE + 0xA9)
#define REG_DISP_TOP_OP2_55_L    (REG_DISP_TOP_OP2_BASE + 0xAA)
#define REG_DISP_TOP_OP2_55_H    (REG_DISP_TOP_OP2_BASE + 0xAB)
#define REG_DISP_TOP_OP2_56_L    (REG_DISP_TOP_OP2_BASE + 0xAC)
#define REG_DISP_TOP_OP2_56_H    (REG_DISP_TOP_OP2_BASE + 0xAD)
#define REG_DISP_TOP_OP2_57_L    (REG_DISP_TOP_OP2_BASE + 0xAE)
#define REG_DISP_TOP_OP2_57_H    (REG_DISP_TOP_OP2_BASE + 0xAF)
#define REG_DISP_TOP_OP2_58_L    (REG_DISP_TOP_OP2_BASE + 0xB0)
#define REG_DISP_TOP_OP2_58_H    (REG_DISP_TOP_OP2_BASE + 0xB1)
#define REG_DISP_TOP_OP2_59_L    (REG_DISP_TOP_OP2_BASE + 0xB2)
#define REG_DISP_TOP_OP2_59_H    (REG_DISP_TOP_OP2_BASE + 0xB3)
#define REG_DISP_TOP_OP2_5A_L    (REG_DISP_TOP_OP2_BASE + 0xB4)
#define REG_DISP_TOP_OP2_5A_H    (REG_DISP_TOP_OP2_BASE + 0xB5)
#define REG_DISP_TOP_OP2_5B_L    (REG_DISP_TOP_OP2_BASE + 0xB6)
#define REG_DISP_TOP_OP2_5B_H    (REG_DISP_TOP_OP2_BASE + 0xB7)
#define REG_DISP_TOP_OP2_5C_L    (REG_DISP_TOP_OP2_BASE + 0xB8)
#define REG_DISP_TOP_OP2_5C_H    (REG_DISP_TOP_OP2_BASE + 0xB9)
#define REG_DISP_TOP_OP2_5D_L    (REG_DISP_TOP_OP2_BASE + 0xBA)
#define REG_DISP_TOP_OP2_5D_H    (REG_DISP_TOP_OP2_BASE + 0xBB)
#define REG_DISP_TOP_OP2_5E_L    (REG_DISP_TOP_OP2_BASE + 0xBC)
#define REG_DISP_TOP_OP2_5E_H    (REG_DISP_TOP_OP2_BASE + 0xBD)
#define REG_DISP_TOP_OP2_5F_L    (REG_DISP_TOP_OP2_BASE + 0xBE)
#define REG_DISP_TOP_OP2_5F_H    (REG_DISP_TOP_OP2_BASE + 0xBF)
#define REG_DISP_TOP_OP2_60_L    (REG_DISP_TOP_OP2_BASE + 0xC0)
#define REG_DISP_TOP_OP2_60_H    (REG_DISP_TOP_OP2_BASE + 0xC1)
#define REG_DISP_TOP_OP2_61_L    (REG_DISP_TOP_OP2_BASE + 0xC2)
#define REG_DISP_TOP_OP2_61_H    (REG_DISP_TOP_OP2_BASE + 0xC3)
#define REG_DISP_TOP_OP2_62_L    (REG_DISP_TOP_OP2_BASE + 0xC4)
#define REG_DISP_TOP_OP2_62_H    (REG_DISP_TOP_OP2_BASE + 0xC5)
#define REG_DISP_TOP_OP2_63_L    (REG_DISP_TOP_OP2_BASE + 0xC6)
#define REG_DISP_TOP_OP2_63_H    (REG_DISP_TOP_OP2_BASE + 0xC7)
#define REG_DISP_TOP_OP2_64_L    (REG_DISP_TOP_OP2_BASE + 0xC8)
#define REG_DISP_TOP_OP2_64_H    (REG_DISP_TOP_OP2_BASE + 0xC9)
#define REG_DISP_TOP_OP2_65_L    (REG_DISP_TOP_OP2_BASE + 0xCA)
#define REG_DISP_TOP_OP2_65_H    (REG_DISP_TOP_OP2_BASE + 0xCB)
#define REG_DISP_TOP_OP2_66_L    (REG_DISP_TOP_OP2_BASE + 0xCC)
#define REG_DISP_TOP_OP2_66_H    (REG_DISP_TOP_OP2_BASE + 0xCD)
#define REG_DISP_TOP_OP2_67_L    (REG_DISP_TOP_OP2_BASE + 0xCE)
#define REG_DISP_TOP_OP2_67_H    (REG_DISP_TOP_OP2_BASE + 0xCF)
#define REG_DISP_TOP_OP2_68_L    (REG_DISP_TOP_OP2_BASE + 0xD0)
#define REG_DISP_TOP_OP2_68_H    (REG_DISP_TOP_OP2_BASE + 0xD1)
#define REG_DISP_TOP_OP2_69_L    (REG_DISP_TOP_OP2_BASE + 0xD2)
#define REG_DISP_TOP_OP2_69_H    (REG_DISP_TOP_OP2_BASE + 0xD3)
#define REG_DISP_TOP_OP2_6A_L    (REG_DISP_TOP_OP2_BASE + 0xD4)
#define REG_DISP_TOP_OP2_6A_H    (REG_DISP_TOP_OP2_BASE + 0xD5)
#define REG_DISP_TOP_OP2_6B_L    (REG_DISP_TOP_OP2_BASE + 0xD6)
#define REG_DISP_TOP_OP2_6B_H    (REG_DISP_TOP_OP2_BASE + 0xD7)
#define REG_DISP_TOP_OP2_6C_L    (REG_DISP_TOP_OP2_BASE + 0xD8)
#define REG_DISP_TOP_OP2_6C_H    (REG_DISP_TOP_OP2_BASE + 0xD9)
#define REG_DISP_TOP_OP2_6D_L    (REG_DISP_TOP_OP2_BASE + 0xDA)
#define REG_DISP_TOP_OP2_6D_H    (REG_DISP_TOP_OP2_BASE + 0xDB)
#define REG_DISP_TOP_OP2_6E_L    (REG_DISP_TOP_OP2_BASE + 0xDC)
#define REG_DISP_TOP_OP2_6E_H    (REG_DISP_TOP_OP2_BASE + 0xDD)
#define REG_DISP_TOP_OP2_6F_L    (REG_DISP_TOP_OP2_BASE + 0xDE)
#define REG_DISP_TOP_OP2_6F_H    (REG_DISP_TOP_OP2_BASE + 0xDF)
#define REG_DISP_TOP_OP2_70_L    (REG_DISP_TOP_OP2_BASE + 0xE0)
#define REG_DISP_TOP_OP2_70_H    (REG_DISP_TOP_OP2_BASE + 0xE1)
#define REG_DISP_TOP_OP2_71_L    (REG_DISP_TOP_OP2_BASE + 0xE2)
#define REG_DISP_TOP_OP2_71_H    (REG_DISP_TOP_OP2_BASE + 0xE3)
#define REG_DISP_TOP_OP2_72_L    (REG_DISP_TOP_OP2_BASE + 0xE4)
#define REG_DISP_TOP_OP2_72_H    (REG_DISP_TOP_OP2_BASE + 0xE5)
#define REG_DISP_TOP_OP2_73_L    (REG_DISP_TOP_OP2_BASE + 0xE6)
#define REG_DISP_TOP_OP2_73_H    (REG_DISP_TOP_OP2_BASE + 0xE7)
#define REG_DISP_TOP_OP2_74_L    (REG_DISP_TOP_OP2_BASE + 0xE8)
#define REG_DISP_TOP_OP2_74_H    (REG_DISP_TOP_OP2_BASE + 0xE9)
#define REG_DISP_TOP_OP2_75_L    (REG_DISP_TOP_OP2_BASE + 0xEA)
#define REG_DISP_TOP_OP2_75_H    (REG_DISP_TOP_OP2_BASE + 0xEB)
#define REG_DISP_TOP_OP2_76_L    (REG_DISP_TOP_OP2_BASE + 0xEC)
#define REG_DISP_TOP_OP2_76_H    (REG_DISP_TOP_OP2_BASE + 0xED)
#define REG_DISP_TOP_OP2_77_L    (REG_DISP_TOP_OP2_BASE + 0xEE)
#define REG_DISP_TOP_OP2_77_H    (REG_DISP_TOP_OP2_BASE + 0xEF)
#define REG_DISP_TOP_OP2_78_L    (REG_DISP_TOP_OP2_BASE + 0xF0)
#define REG_DISP_TOP_OP2_78_H    (REG_DISP_TOP_OP2_BASE + 0xF1)
#define REG_DISP_TOP_OP2_79_L    (REG_DISP_TOP_OP2_BASE + 0xF2)
#define REG_DISP_TOP_OP2_79_H    (REG_DISP_TOP_OP2_BASE + 0xF3)
#define REG_DISP_TOP_OP2_7A_L    (REG_DISP_TOP_OP2_BASE + 0xF4)
#define REG_DISP_TOP_OP2_7A_H    (REG_DISP_TOP_OP2_BASE + 0xF5)
#define REG_DISP_TOP_OP2_7B_L    (REG_DISP_TOP_OP2_BASE + 0xF6)
#define REG_DISP_TOP_OP2_7B_H    (REG_DISP_TOP_OP2_BASE + 0xF7)
#define REG_DISP_TOP_OP2_7C_L    (REG_DISP_TOP_OP2_BASE + 0xF8)
#define REG_DISP_TOP_OP2_7C_H    (REG_DISP_TOP_OP2_BASE + 0xF9)
#define REG_DISP_TOP_OP2_7D_L    (REG_DISP_TOP_OP2_BASE + 0xFA)
#define REG_DISP_TOP_OP2_7D_H    (REG_DISP_TOP_OP2_BASE + 0xFB)
#define REG_DISP_TOP_OP2_7E_L    (REG_DISP_TOP_OP2_BASE + 0xFC)
#define REG_DISP_TOP_OP2_7E_H    (REG_DISP_TOP_OP2_BASE + 0xFD)
#define REG_DISP_TOP_OP2_7F_L    (REG_DISP_TOP_OP2_BASE + 0xFE)
#define REG_DISP_TOP_OP2_7F_H    (REG_DISP_TOP_OP2_BASE + 0xFF)

#define REG_DPHY_00_L           (REG_DPHY_BASE + 0x00)
#define REG_DPHY_00_H           (REG_DPHY_BASE + 0x01)
#define REG_DPHY_01_L           (REG_DPHY_BASE + 0x02)
#define REG_DPHY_01_H           (REG_DPHY_BASE + 0x03)
#define REG_DPHY_02_L           (REG_DPHY_BASE + 0x04)
#define REG_DPHY_02_H           (REG_DPHY_BASE + 0x05)
#define REG_DPHY_03_L           (REG_DPHY_BASE + 0x06)
#define REG_DPHY_03_H           (REG_DPHY_BASE + 0x07)
#define REG_DPHY_04_L           (REG_DPHY_BASE + 0x08)
#define REG_DPHY_04_H           (REG_DPHY_BASE + 0x09)
#define REG_DPHY_05_L           (REG_DPHY_BASE + 0x0A)
#define REG_DPHY_05_H           (REG_DPHY_BASE + 0x0B)
#define REG_DPHY_06_L           (REG_DPHY_BASE + 0x0C)
#define REG_DPHY_06_H           (REG_DPHY_BASE + 0x0D)
#define REG_DPHY_07_L           (REG_DPHY_BASE + 0x0E)
#define REG_DPHY_07_H           (REG_DPHY_BASE + 0x0F)
#define REG_DPHY_08_L           (REG_DPHY_BASE + 0x10)
#define REG_DPHY_08_H           (REG_DPHY_BASE + 0x11)
#define REG_DPHY_09_L           (REG_DPHY_BASE + 0x12)
#define REG_DPHY_09_H           (REG_DPHY_BASE + 0x13)
#define REG_DPHY_0A_L           (REG_DPHY_BASE + 0x14)
#define REG_DPHY_0A_H           (REG_DPHY_BASE + 0x15)
#define REG_DPHY_0B_L           (REG_DPHY_BASE + 0x16)
#define REG_DPHY_0B_H           (REG_DPHY_BASE + 0x17)
#define REG_DPHY_0C_L           (REG_DPHY_BASE + 0x18)
#define REG_DPHY_0C_H           (REG_DPHY_BASE + 0x19)
#define REG_DPHY_0D_L           (REG_DPHY_BASE + 0x1A)
#define REG_DPHY_0D_H           (REG_DPHY_BASE + 0x1B)
#define REG_DPHY_0E_L           (REG_DPHY_BASE + 0x1C)
#define REG_DPHY_0E_H           (REG_DPHY_BASE + 0x1D)
#define REG_DPHY_0F_L           (REG_DPHY_BASE + 0x1E)
#define REG_DPHY_0F_H           (REG_DPHY_BASE + 0x1F)
#define REG_DPHY_10_L           (REG_DPHY_BASE + 0x20)
#define REG_DPHY_10_H           (REG_DPHY_BASE + 0x21)
#define REG_DPHY_11_L           (REG_DPHY_BASE + 0x22)
#define REG_DPHY_11_H           (REG_DPHY_BASE + 0x23)
#define REG_DPHY_12_L           (REG_DPHY_BASE + 0x24)
#define REG_DPHY_12_H           (REG_DPHY_BASE + 0x25)
#define REG_DPHY_13_L           (REG_DPHY_BASE + 0x26)
#define REG_DPHY_13_H           (REG_DPHY_BASE + 0x27)
#define REG_DPHY_14_L           (REG_DPHY_BASE + 0x28)
#define REG_DPHY_14_H           (REG_DPHY_BASE + 0x29)
#define REG_DPHY_15_L           (REG_DPHY_BASE + 0x2A)
#define REG_DPHY_15_H           (REG_DPHY_BASE + 0x2B)
#define REG_DPHY_16_L           (REG_DPHY_BASE + 0x2C)
#define REG_DPHY_16_H           (REG_DPHY_BASE + 0x2D)
#define REG_DPHY_17_L           (REG_DPHY_BASE + 0x2E)
#define REG_DPHY_17_H           (REG_DPHY_BASE + 0x2F)
#define REG_DPHY_18_L           (REG_DPHY_BASE + 0x30)
#define REG_DPHY_18_H           (REG_DPHY_BASE + 0x31)
#define REG_DPHY_19_L           (REG_DPHY_BASE + 0x32)
#define REG_DPHY_19_H           (REG_DPHY_BASE + 0x33)
#define REG_DPHY_1A_L           (REG_DPHY_BASE + 0x34)
#define REG_DPHY_1A_H           (REG_DPHY_BASE + 0x35)
#define REG_DPHY_1B_L           (REG_DPHY_BASE + 0x36)
#define REG_DPHY_1B_H           (REG_DPHY_BASE + 0x37)
#define REG_DPHY_1C_L           (REG_DPHY_BASE + 0x38)
#define REG_DPHY_1C_H           (REG_DPHY_BASE + 0x39)
#define REG_DPHY_1D_L           (REG_DPHY_BASE + 0x3A)
#define REG_DPHY_1D_H           (REG_DPHY_BASE + 0x3B)
#define REG_DPHY_1E_L           (REG_DPHY_BASE + 0x3C)
#define REG_DPHY_1E_H           (REG_DPHY_BASE + 0x3D)
#define REG_DPHY_1F_L           (REG_DPHY_BASE + 0x3E)
#define REG_DPHY_1F_H           (REG_DPHY_BASE + 0x3F)
#define REG_DPHY_20_L           (REG_DPHY_BASE + 0x40)
#define REG_DPHY_20_H           (REG_DPHY_BASE + 0x41)
#define REG_DPHY_21_L           (REG_DPHY_BASE + 0x42)
#define REG_DPHY_21_H           (REG_DPHY_BASE + 0x43)
#define REG_DPHY_22_L           (REG_DPHY_BASE + 0x44)
#define REG_DPHY_22_H           (REG_DPHY_BASE + 0x45)
#define REG_DPHY_23_L           (REG_DPHY_BASE + 0x46)
#define REG_DPHY_23_H           (REG_DPHY_BASE + 0x47)
#define REG_DPHY_24_L           (REG_DPHY_BASE + 0x48)
#define REG_DPHY_24_H           (REG_DPHY_BASE + 0x49)
#define REG_DPHY_25_L           (REG_DPHY_BASE + 0x4A)
#define REG_DPHY_25_H           (REG_DPHY_BASE + 0x4B)
#define REG_DPHY_26_L           (REG_DPHY_BASE + 0x4C)
#define REG_DPHY_26_H           (REG_DPHY_BASE + 0x4D)
#define REG_DPHY_27_L           (REG_DPHY_BASE + 0x4E)
#define REG_DPHY_27_H           (REG_DPHY_BASE + 0x4F)
#define REG_DPHY_28_L           (REG_DPHY_BASE + 0x50)
#define REG_DPHY_28_H           (REG_DPHY_BASE + 0x51)
#define REG_DPHY_29_L           (REG_DPHY_BASE + 0x52)
#define REG_DPHY_29_H           (REG_DPHY_BASE + 0x53)
#define REG_DPHY_2A_L           (REG_DPHY_BASE + 0x54)
#define REG_DPHY_2A_H           (REG_DPHY_BASE + 0x55)
#define REG_DPHY_2B_L           (REG_DPHY_BASE + 0x56)
#define REG_DPHY_2B_H           (REG_DPHY_BASE + 0x57)
#define REG_DPHY_2C_L           (REG_DPHY_BASE + 0x58)
#define REG_DPHY_2C_H           (REG_DPHY_BASE + 0x59)
#define REG_DPHY_2D_L           (REG_DPHY_BASE + 0x5A)
#define REG_DPHY_2D_H           (REG_DPHY_BASE + 0x5B)
#define REG_DPHY_2E_L           (REG_DPHY_BASE + 0x5C)
#define REG_DPHY_2E_H           (REG_DPHY_BASE + 0x5D)
#define REG_DPHY_2F_L           (REG_DPHY_BASE + 0x5E)
#define REG_DPHY_2F_H           (REG_DPHY_BASE + 0x5F)
#define REG_DPHY_30_L           (REG_DPHY_BASE + 0x60)
#define REG_DPHY_30_H           (REG_DPHY_BASE + 0x61)
#define REG_DPHY_31_L           (REG_DPHY_BASE + 0x62)
#define REG_DPHY_31_H           (REG_DPHY_BASE + 0x63)
#define REG_DPHY_32_L           (REG_DPHY_BASE + 0x64)
#define REG_DPHY_32_H           (REG_DPHY_BASE + 0x65)
#define REG_DPHY_33_L           (REG_DPHY_BASE + 0x66)
#define REG_DPHY_33_H           (REG_DPHY_BASE + 0x67)
#define REG_DPHY_34_L           (REG_DPHY_BASE + 0x68)
#define REG_DPHY_34_H           (REG_DPHY_BASE + 0x69)
#define REG_DPHY_35_L           (REG_DPHY_BASE + 0x6A)
#define REG_DPHY_35_H           (REG_DPHY_BASE + 0x6B)
#define REG_DPHY_36_L           (REG_DPHY_BASE + 0x6C)
#define REG_DPHY_36_H           (REG_DPHY_BASE + 0x6D)
#define REG_DPHY_37_L           (REG_DPHY_BASE + 0x6E)
#define REG_DPHY_37_H           (REG_DPHY_BASE + 0x6F)
#define REG_DPHY_38_L           (REG_DPHY_BASE + 0x70)
#define REG_DPHY_38_H           (REG_DPHY_BASE + 0x71)
#define REG_DPHY_39_L           (REG_DPHY_BASE + 0x72)
#define REG_DPHY_39_H           (REG_DPHY_BASE + 0x73)
#define REG_DPHY_3A_L           (REG_DPHY_BASE + 0x74)
#define REG_DPHY_3A_H           (REG_DPHY_BASE + 0x75)
#define REG_DPHY_3B_L           (REG_DPHY_BASE + 0x76)
#define REG_DPHY_3B_H           (REG_DPHY_BASE + 0x77)
#define REG_DPHY_3C_L           (REG_DPHY_BASE + 0x78)
#define REG_DPHY_3C_H           (REG_DPHY_BASE + 0x79)
#define REG_DPHY_3D_L           (REG_DPHY_BASE + 0x7A)
#define REG_DPHY_3D_H           (REG_DPHY_BASE + 0x7B)
#define REG_DPHY_3E_L           (REG_DPHY_BASE + 0x7C)
#define REG_DPHY_3E_H           (REG_DPHY_BASE + 0x7D)
#define REG_DPHY_3F_L           (REG_DPHY_BASE + 0x7E)
#define REG_DPHY_3F_H           (REG_DPHY_BASE + 0x7F)
#define REG_DPHY_40_L           (REG_DPHY_BASE + 0x80)
#define REG_DPHY_40_H           (REG_DPHY_BASE + 0x81)
#define REG_DPHY_41_L           (REG_DPHY_BASE + 0x82)
#define REG_DPHY_41_H           (REG_DPHY_BASE + 0x83)
#define REG_DPHY_42_L           (REG_DPHY_BASE + 0x84)
#define REG_DPHY_42_H           (REG_DPHY_BASE + 0x85)
#define REG_DPHY_43_L           (REG_DPHY_BASE + 0x86)
#define REG_DPHY_43_H           (REG_DPHY_BASE + 0x87)
#define REG_DPHY_44_L           (REG_DPHY_BASE + 0x88)
#define REG_DPHY_44_H           (REG_DPHY_BASE + 0x89)
#define REG_DPHY_45_L           (REG_DPHY_BASE + 0x8A)
#define REG_DPHY_45_H           (REG_DPHY_BASE + 0x8B)
#define REG_DPHY_46_L           (REG_DPHY_BASE + 0x8C)
#define REG_DPHY_46_H           (REG_DPHY_BASE + 0x8D)
#define REG_DPHY_47_L           (REG_DPHY_BASE + 0x8E)
#define REG_DPHY_47_H           (REG_DPHY_BASE + 0x8F)
#define REG_DPHY_48_L           (REG_DPHY_BASE + 0x90)
#define REG_DPHY_48_H           (REG_DPHY_BASE + 0x91)
#define REG_DPHY_49_L           (REG_DPHY_BASE + 0x92)
#define REG_DPHY_49_H           (REG_DPHY_BASE + 0x93)
#define REG_DPHY_4A_L           (REG_DPHY_BASE + 0x94)
#define REG_DPHY_4A_H           (REG_DPHY_BASE + 0x95)
#define REG_DPHY_4B_L           (REG_DPHY_BASE + 0x96)
#define REG_DPHY_4B_H           (REG_DPHY_BASE + 0x97)
#define REG_DPHY_4C_L           (REG_DPHY_BASE + 0x98)
#define REG_DPHY_4C_H           (REG_DPHY_BASE + 0x99)
#define REG_DPHY_4D_L           (REG_DPHY_BASE + 0x9A)
#define REG_DPHY_4D_H           (REG_DPHY_BASE + 0x9B)
#define REG_DPHY_4E_L           (REG_DPHY_BASE + 0x9C)
#define REG_DPHY_4E_H           (REG_DPHY_BASE + 0x9D)
#define REG_DPHY_4F_L           (REG_DPHY_BASE + 0x9E)
#define REG_DPHY_4F_H           (REG_DPHY_BASE + 0x9F)
#define REG_DPHY_50_L           (REG_DPHY_BASE + 0xA0)
#define REG_DPHY_50_H           (REG_DPHY_BASE + 0xA1)
#define REG_DPHY_51_L           (REG_DPHY_BASE + 0xA2)
#define REG_DPHY_51_H           (REG_DPHY_BASE + 0xA3)
#define REG_DPHY_52_L           (REG_DPHY_BASE + 0xA4)
#define REG_DPHY_52_H           (REG_DPHY_BASE + 0xA5)
#define REG_DPHY_53_L           (REG_DPHY_BASE + 0xA6)
#define REG_DPHY_53_H           (REG_DPHY_BASE + 0xA7)
#define REG_DPHY_54_L           (REG_DPHY_BASE + 0xA8)
#define REG_DPHY_54_H           (REG_DPHY_BASE + 0xA9)
#define REG_DPHY_55_L           (REG_DPHY_BASE + 0xAA)
#define REG_DPHY_55_H           (REG_DPHY_BASE + 0xAB)
#define REG_DPHY_56_L           (REG_DPHY_BASE + 0xAC)
#define REG_DPHY_56_H           (REG_DPHY_BASE + 0xAD)
#define REG_DPHY_57_L           (REG_DPHY_BASE + 0xAE)
#define REG_DPHY_57_H           (REG_DPHY_BASE + 0xAF)
#define REG_DPHY_58_L           (REG_DPHY_BASE + 0xB0)
#define REG_DPHY_58_H           (REG_DPHY_BASE + 0xB1)
#define REG_DPHY_59_L           (REG_DPHY_BASE + 0xB2)
#define REG_DPHY_59_H           (REG_DPHY_BASE + 0xB3)
#define REG_DPHY_5A_L           (REG_DPHY_BASE + 0xB4)
#define REG_DPHY_5A_H           (REG_DPHY_BASE + 0xB5)
#define REG_DPHY_5B_L           (REG_DPHY_BASE + 0xB6)
#define REG_DPHY_5B_H           (REG_DPHY_BASE + 0xB7)
#define REG_DPHY_5C_L           (REG_DPHY_BASE + 0xB8)
#define REG_DPHY_5C_H           (REG_DPHY_BASE + 0xB9)
#define REG_DPHY_5D_L           (REG_DPHY_BASE + 0xBA)
#define REG_DPHY_5D_H           (REG_DPHY_BASE + 0xBB)
#define REG_DPHY_5E_L           (REG_DPHY_BASE + 0xBC)
#define REG_DPHY_5E_H           (REG_DPHY_BASE + 0xBD)
#define REG_DPHY_5F_L           (REG_DPHY_BASE + 0xBE)
#define REG_DPHY_5F_H           (REG_DPHY_BASE + 0xBF)
#define REG_DPHY_60_L           (REG_DPHY_BASE + 0xC0)
#define REG_DPHY_60_H           (REG_DPHY_BASE + 0xC1)
#define REG_DPHY_61_L           (REG_DPHY_BASE + 0xC2)
#define REG_DPHY_61_H           (REG_DPHY_BASE + 0xC3)
#define REG_DPHY_62_L           (REG_DPHY_BASE + 0xC4)
#define REG_DPHY_62_H           (REG_DPHY_BASE + 0xC5)
#define REG_DPHY_63_L           (REG_DPHY_BASE + 0xC6)
#define REG_DPHY_63_H           (REG_DPHY_BASE + 0xC7)
#define REG_DPHY_64_L           (REG_DPHY_BASE + 0xC8)
#define REG_DPHY_64_H           (REG_DPHY_BASE + 0xC9)
#define REG_DPHY_65_L           (REG_DPHY_BASE + 0xCA)
#define REG_DPHY_65_H           (REG_DPHY_BASE + 0xCB)
#define REG_DPHY_66_L           (REG_DPHY_BASE + 0xCC)
#define REG_DPHY_66_H           (REG_DPHY_BASE + 0xCD)
#define REG_DPHY_67_L           (REG_DPHY_BASE + 0xCE)
#define REG_DPHY_67_H           (REG_DPHY_BASE + 0xCF)
#define REG_DPHY_68_L           (REG_DPHY_BASE + 0xD0)
#define REG_DPHY_68_H           (REG_DPHY_BASE + 0xD1)
#define REG_DPHY_69_L           (REG_DPHY_BASE + 0xD2)
#define REG_DPHY_69_H           (REG_DPHY_BASE + 0xD3)
#define REG_DPHY_6A_L           (REG_DPHY_BASE + 0xD4)
#define REG_DPHY_6A_H           (REG_DPHY_BASE + 0xD5)
#define REG_DPHY_6B_L           (REG_DPHY_BASE + 0xD6)
#define REG_DPHY_6B_H           (REG_DPHY_BASE + 0xD7)
#define REG_DPHY_6C_L           (REG_DPHY_BASE + 0xD8)
#define REG_DPHY_6C_H           (REG_DPHY_BASE + 0xD9)
#define REG_DPHY_6D_L           (REG_DPHY_BASE + 0xDA)
#define REG_DPHY_6D_H           (REG_DPHY_BASE + 0xDB)
#define REG_DPHY_6E_L           (REG_DPHY_BASE + 0xDC)
#define REG_DPHY_6E_H           (REG_DPHY_BASE + 0xDD)
#define REG_DPHY_6F_L           (REG_DPHY_BASE + 0xDE)
#define REG_DPHY_6F_H           (REG_DPHY_BASE + 0xDF)
#define REG_DPHY_70_L           (REG_DPHY_BASE + 0xE0)
#define REG_DPHY_70_H           (REG_DPHY_BASE + 0xE1)
#define REG_DPHY_71_L           (REG_DPHY_BASE + 0xE2)
#define REG_DPHY_71_H           (REG_DPHY_BASE + 0xE3)
#define REG_DPHY_72_L           (REG_DPHY_BASE + 0xE4)
#define REG_DPHY_72_H           (REG_DPHY_BASE + 0xE5)
#define REG_DPHY_73_L           (REG_DPHY_BASE + 0xE6)
#define REG_DPHY_73_H           (REG_DPHY_BASE + 0xE7)
#define REG_DPHY_74_L           (REG_DPHY_BASE + 0xE8)
#define REG_DPHY_74_H           (REG_DPHY_BASE + 0xE9)
#define REG_DPHY_75_L           (REG_DPHY_BASE + 0xEA)
#define REG_DPHY_75_H           (REG_DPHY_BASE + 0xEB)
#define REG_DPHY_76_L           (REG_DPHY_BASE + 0xEC)
#define REG_DPHY_76_H           (REG_DPHY_BASE + 0xED)
#define REG_DPHY_77_L           (REG_DPHY_BASE + 0xEE)
#define REG_DPHY_77_H           (REG_DPHY_BASE + 0xEF)
#define REG_DPHY_78_L           (REG_DPHY_BASE + 0xF0)
#define REG_DPHY_78_H           (REG_DPHY_BASE + 0xF1)
#define REG_DPHY_79_L           (REG_DPHY_BASE + 0xF2)
#define REG_DPHY_79_H           (REG_DPHY_BASE + 0xF3)
#define REG_DPHY_7A_L           (REG_DPHY_BASE + 0xF4)
#define REG_DPHY_7A_H           (REG_DPHY_BASE + 0xF5)
#define REG_DPHY_7B_L           (REG_DPHY_BASE + 0xF6)
#define REG_DPHY_7B_H           (REG_DPHY_BASE + 0xF7)
#define REG_DPHY_7C_L           (REG_DPHY_BASE + 0xF8)
#define REG_DPHY_7C_H           (REG_DPHY_BASE + 0xF9)
#define REG_DPHY_7D_L           (REG_DPHY_BASE + 0xFA)
#define REG_DPHY_7D_H           (REG_DPHY_BASE + 0xFB)
#define REG_DPHY_7E_L           (REG_DPHY_BASE + 0xFC)
#define REG_DPHY_7E_H           (REG_DPHY_BASE + 0xFD)
#define REG_DPHY_7F_L           (REG_DPHY_BASE + 0xFE)
#define REG_DPHY_7F_H           (REG_DPHY_BASE + 0xFF)

#define REG_PM_TOP_00_L         (REG_PM_TOP_BASE + 0x00)
#define REG_PM_TOP_00_H         (REG_PM_TOP_BASE + 0x01)
#define REG_PM_TOP_01_L         (REG_PM_TOP_BASE + 0x02)
#define REG_PM_TOP_01_H         (REG_PM_TOP_BASE + 0x03)
#define REG_PM_TOP_02_L         (REG_PM_TOP_BASE + 0x04)
#define REG_PM_TOP_02_H         (REG_PM_TOP_BASE + 0x05)
#define REG_PM_TOP_03_L         (REG_PM_TOP_BASE + 0x06)
#define REG_PM_TOP_03_H         (REG_PM_TOP_BASE + 0x07)
#define REG_PM_TOP_04_L         (REG_PM_TOP_BASE + 0x08)
#define REG_PM_TOP_04_H         (REG_PM_TOP_BASE + 0x09)
#define REG_PM_TOP_05_L         (REG_PM_TOP_BASE + 0x0A)
#define REG_PM_TOP_05_H         (REG_PM_TOP_BASE + 0x0B)
#define REG_PM_TOP_06_L         (REG_PM_TOP_BASE + 0x0C)
#define REG_PM_TOP_06_H         (REG_PM_TOP_BASE + 0x0D)
#define REG_PM_TOP_07_L         (REG_PM_TOP_BASE + 0x0E)
#define REG_PM_TOP_07_H         (REG_PM_TOP_BASE + 0x0F)
#define REG_PM_TOP_08_L         (REG_PM_TOP_BASE + 0x10)
#define REG_PM_TOP_08_H         (REG_PM_TOP_BASE + 0x11)
#define REG_PM_TOP_09_L         (REG_PM_TOP_BASE + 0x12)
#define REG_PM_TOP_09_H         (REG_PM_TOP_BASE + 0x13)
#define REG_PM_TOP_0A_L         (REG_PM_TOP_BASE + 0x14)
#define REG_PM_TOP_0A_H         (REG_PM_TOP_BASE + 0x15)
#define REG_PM_TOP_0B_L         (REG_PM_TOP_BASE + 0x16)
#define REG_PM_TOP_0B_H         (REG_PM_TOP_BASE + 0x17)
#define REG_PM_TOP_0C_L         (REG_PM_TOP_BASE + 0x18)
#define REG_PM_TOP_0C_H         (REG_PM_TOP_BASE + 0x19)
#define REG_PM_TOP_0D_L         (REG_PM_TOP_BASE + 0x1A)
#define REG_PM_TOP_0D_H         (REG_PM_TOP_BASE + 0x1B)
#define REG_PM_TOP_0E_L         (REG_PM_TOP_BASE + 0x1C)
#define REG_PM_TOP_0E_H         (REG_PM_TOP_BASE + 0x1D)
#define REG_PM_TOP_0F_L         (REG_PM_TOP_BASE + 0x1E)
#define REG_PM_TOP_0F_H         (REG_PM_TOP_BASE + 0x1F)
#define REG_PM_TOP_10_L         (REG_PM_TOP_BASE + 0x20)
#define REG_PM_TOP_10_H         (REG_PM_TOP_BASE + 0x21)
#define REG_PM_TOP_11_L         (REG_PM_TOP_BASE + 0x22)
#define REG_PM_TOP_11_H         (REG_PM_TOP_BASE + 0x23)
#define REG_PM_TOP_12_L         (REG_PM_TOP_BASE + 0x24)
#define REG_PM_TOP_12_H         (REG_PM_TOP_BASE + 0x25)
#define REG_PM_TOP_13_L         (REG_PM_TOP_BASE + 0x26)
#define REG_PM_TOP_13_H         (REG_PM_TOP_BASE + 0x27)
#define REG_PM_TOP_14_L         (REG_PM_TOP_BASE + 0x28)
#define REG_PM_TOP_14_H         (REG_PM_TOP_BASE + 0x29)
#define REG_PM_TOP_15_L         (REG_PM_TOP_BASE + 0x2A)
#define REG_PM_TOP_15_H         (REG_PM_TOP_BASE + 0x2B)
#define REG_PM_TOP_16_L         (REG_PM_TOP_BASE + 0x2C)
#define REG_PM_TOP_16_H         (REG_PM_TOP_BASE + 0x2D)
#define REG_PM_TOP_17_L         (REG_PM_TOP_BASE + 0x2E)
#define REG_PM_TOP_17_H         (REG_PM_TOP_BASE + 0x2F)
#define REG_PM_TOP_18_L         (REG_PM_TOP_BASE + 0x30)
#define REG_PM_TOP_18_H         (REG_PM_TOP_BASE + 0x31)
#define REG_PM_TOP_19_L         (REG_PM_TOP_BASE + 0x32)
#define REG_PM_TOP_19_H         (REG_PM_TOP_BASE + 0x33)
#define REG_PM_TOP_1A_L         (REG_PM_TOP_BASE + 0x34)
#define REG_PM_TOP_1A_H         (REG_PM_TOP_BASE + 0x35)
#define REG_PM_TOP_1B_L         (REG_PM_TOP_BASE + 0x36)
#define REG_PM_TOP_1B_H         (REG_PM_TOP_BASE + 0x37)
#define REG_PM_TOP_1C_L         (REG_PM_TOP_BASE + 0x38)
#define REG_PM_TOP_1C_H         (REG_PM_TOP_BASE + 0x39)
#define REG_PM_TOP_1D_L         (REG_PM_TOP_BASE + 0x3A)
#define REG_PM_TOP_1D_H         (REG_PM_TOP_BASE + 0x3B)
#define REG_PM_TOP_1E_L         (REG_PM_TOP_BASE + 0x3C)
#define REG_PM_TOP_1E_H         (REG_PM_TOP_BASE + 0x3D)
#define REG_PM_TOP_1F_L         (REG_PM_TOP_BASE + 0x3E)
#define REG_PM_TOP_1F_H         (REG_PM_TOP_BASE + 0x3F)
#define REG_PM_TOP_20_L         (REG_PM_TOP_BASE + 0x40)
#define REG_PM_TOP_20_H         (REG_PM_TOP_BASE + 0x41)
#define REG_PM_TOP_21_L         (REG_PM_TOP_BASE + 0x42)
#define REG_PM_TOP_21_H         (REG_PM_TOP_BASE + 0x43)
#define REG_PM_TOP_22_L         (REG_PM_TOP_BASE + 0x44)
#define REG_PM_TOP_22_H         (REG_PM_TOP_BASE + 0x45)
#define REG_PM_TOP_23_L         (REG_PM_TOP_BASE + 0x46)
#define REG_PM_TOP_23_H         (REG_PM_TOP_BASE + 0x47)
#define REG_PM_TOP_24_L         (REG_PM_TOP_BASE + 0x48)
#define REG_PM_TOP_24_H         (REG_PM_TOP_BASE + 0x49)
#define REG_PM_TOP_25_L         (REG_PM_TOP_BASE + 0x4A)
#define REG_PM_TOP_25_H         (REG_PM_TOP_BASE + 0x4B)
#define REG_PM_TOP_26_L         (REG_PM_TOP_BASE + 0x4C)
#define REG_PM_TOP_26_H         (REG_PM_TOP_BASE + 0x4D)
#define REG_PM_TOP_27_L         (REG_PM_TOP_BASE + 0x4E)
#define REG_PM_TOP_27_H         (REG_PM_TOP_BASE + 0x4F)
#define REG_PM_TOP_28_L         (REG_PM_TOP_BASE + 0x50)
#define REG_PM_TOP_28_H         (REG_PM_TOP_BASE + 0x51)
#define REG_PM_TOP_29_L         (REG_PM_TOP_BASE + 0x52)
#define REG_PM_TOP_29_H         (REG_PM_TOP_BASE + 0x53)
#define REG_PM_TOP_2A_L         (REG_PM_TOP_BASE + 0x54)
#define REG_PM_TOP_2A_H         (REG_PM_TOP_BASE + 0x55)
#define REG_PM_TOP_2B_L         (REG_PM_TOP_BASE + 0x56)
#define REG_PM_TOP_2B_H         (REG_PM_TOP_BASE + 0x57)
#define REG_PM_TOP_2C_L         (REG_PM_TOP_BASE + 0x58)
#define REG_PM_TOP_2C_H         (REG_PM_TOP_BASE + 0x59)
#define REG_PM_TOP_2D_L         (REG_PM_TOP_BASE + 0x5A)
#define REG_PM_TOP_2D_H         (REG_PM_TOP_BASE + 0x5B)
#define REG_PM_TOP_2E_L         (REG_PM_TOP_BASE + 0x5C)
#define REG_PM_TOP_2E_H         (REG_PM_TOP_BASE + 0x5D)
#define REG_PM_TOP_2F_L         (REG_PM_TOP_BASE + 0x5E)
#define REG_PM_TOP_2F_H         (REG_PM_TOP_BASE + 0x5F)
#define REG_PM_TOP_30_L         (REG_PM_TOP_BASE + 0x60)
#define REG_PM_TOP_30_H         (REG_PM_TOP_BASE + 0x61)
#define REG_PM_TOP_31_L         (REG_PM_TOP_BASE + 0x62)
#define REG_PM_TOP_31_H         (REG_PM_TOP_BASE + 0x63)
#define REG_PM_TOP_32_L         (REG_PM_TOP_BASE + 0x64)
#define REG_PM_TOP_32_H         (REG_PM_TOP_BASE + 0x65)
#define REG_PM_TOP_33_L         (REG_PM_TOP_BASE + 0x66)
#define REG_PM_TOP_33_H         (REG_PM_TOP_BASE + 0x67)
#define REG_PM_TOP_34_L         (REG_PM_TOP_BASE + 0x68)
#define REG_PM_TOP_34_H         (REG_PM_TOP_BASE + 0x69)
#define REG_PM_TOP_35_L         (REG_PM_TOP_BASE + 0x6A)
#define REG_PM_TOP_35_H         (REG_PM_TOP_BASE + 0x6B)
#define REG_PM_TOP_36_L         (REG_PM_TOP_BASE + 0x6C)
#define REG_PM_TOP_36_H         (REG_PM_TOP_BASE + 0x6D)
#define REG_PM_TOP_37_L         (REG_PM_TOP_BASE + 0x6E)
#define REG_PM_TOP_37_H         (REG_PM_TOP_BASE + 0x6F)
#define REG_PM_TOP_38_L         (REG_PM_TOP_BASE + 0x70)
#define REG_PM_TOP_38_H         (REG_PM_TOP_BASE + 0x71)
#define REG_PM_TOP_39_L         (REG_PM_TOP_BASE + 0x72)
#define REG_PM_TOP_39_H         (REG_PM_TOP_BASE + 0x73)
#define REG_PM_TOP_3A_L         (REG_PM_TOP_BASE + 0x74)
#define REG_PM_TOP_3A_H         (REG_PM_TOP_BASE + 0x75)
#define REG_PM_TOP_3B_L         (REG_PM_TOP_BASE + 0x76)
#define REG_PM_TOP_3B_H         (REG_PM_TOP_BASE + 0x77)
#define REG_PM_TOP_3C_L         (REG_PM_TOP_BASE + 0x78)
#define REG_PM_TOP_3C_H         (REG_PM_TOP_BASE + 0x79)
#define REG_PM_TOP_3D_L         (REG_PM_TOP_BASE + 0x7A)
#define REG_PM_TOP_3D_H         (REG_PM_TOP_BASE + 0x7B)
#define REG_PM_TOP_3E_L         (REG_PM_TOP_BASE + 0x7C)
#define REG_PM_TOP_3E_H         (REG_PM_TOP_BASE + 0x7D)
#define REG_PM_TOP_3F_L         (REG_PM_TOP_BASE + 0x7E)
#define REG_PM_TOP_3F_H         (REG_PM_TOP_BASE + 0x7F)
#define REG_PM_TOP_40_L         (REG_PM_TOP_BASE + 0x80)
#define REG_PM_TOP_40_H         (REG_PM_TOP_BASE + 0x81)
#define REG_PM_TOP_41_L         (REG_PM_TOP_BASE + 0x82)
#define REG_PM_TOP_41_H         (REG_PM_TOP_BASE + 0x83)
#define REG_PM_TOP_42_L         (REG_PM_TOP_BASE + 0x84)
#define REG_PM_TOP_42_H         (REG_PM_TOP_BASE + 0x85)
#define REG_PM_TOP_43_L         (REG_PM_TOP_BASE + 0x86)
#define REG_PM_TOP_43_H         (REG_PM_TOP_BASE + 0x87)
#define REG_PM_TOP_44_L         (REG_PM_TOP_BASE + 0x88)
#define REG_PM_TOP_44_H         (REG_PM_TOP_BASE + 0x89)
#define REG_PM_TOP_45_L         (REG_PM_TOP_BASE + 0x8A)
#define REG_PM_TOP_45_H         (REG_PM_TOP_BASE + 0x8B)
#define REG_PM_TOP_46_L         (REG_PM_TOP_BASE + 0x8C)
#define REG_PM_TOP_46_H         (REG_PM_TOP_BASE + 0x8D)
#define REG_PM_TOP_47_L         (REG_PM_TOP_BASE + 0x8E)
#define REG_PM_TOP_47_H         (REG_PM_TOP_BASE + 0x8F)
#define REG_PM_TOP_48_L         (REG_PM_TOP_BASE + 0x90)
#define REG_PM_TOP_48_H         (REG_PM_TOP_BASE + 0x91)
#define REG_PM_TOP_49_L         (REG_PM_TOP_BASE + 0x92)
#define REG_PM_TOP_49_H         (REG_PM_TOP_BASE + 0x93)
#define REG_PM_TOP_4A_L         (REG_PM_TOP_BASE + 0x94)
#define REG_PM_TOP_4A_H         (REG_PM_TOP_BASE + 0x95)
#define REG_PM_TOP_4B_L         (REG_PM_TOP_BASE + 0x96)
#define REG_PM_TOP_4B_H         (REG_PM_TOP_BASE + 0x97)
#define REG_PM_TOP_4C_L         (REG_PM_TOP_BASE + 0x98)
#define REG_PM_TOP_4C_H         (REG_PM_TOP_BASE + 0x99)
#define REG_PM_TOP_4D_L         (REG_PM_TOP_BASE + 0x9A)
#define REG_PM_TOP_4D_H         (REG_PM_TOP_BASE + 0x9B)
#define REG_PM_TOP_4E_L         (REG_PM_TOP_BASE + 0x9C)
#define REG_PM_TOP_4E_H         (REG_PM_TOP_BASE + 0x9D)
#define REG_PM_TOP_4F_L         (REG_PM_TOP_BASE + 0x9E)
#define REG_PM_TOP_4F_H         (REG_PM_TOP_BASE + 0x9F)
#define REG_PM_TOP_50_L         (REG_PM_TOP_BASE + 0xA0)
#define REG_PM_TOP_50_H         (REG_PM_TOP_BASE + 0xA1)
#define REG_PM_TOP_51_L         (REG_PM_TOP_BASE + 0xA2)
#define REG_PM_TOP_51_H         (REG_PM_TOP_BASE + 0xA3)
#define REG_PM_TOP_52_L         (REG_PM_TOP_BASE + 0xA4)
#define REG_PM_TOP_52_H         (REG_PM_TOP_BASE + 0xA5)
#define REG_PM_TOP_53_L         (REG_PM_TOP_BASE + 0xA6)
#define REG_PM_TOP_53_H         (REG_PM_TOP_BASE + 0xA7)
#define REG_PM_TOP_54_L         (REG_PM_TOP_BASE + 0xA8)
#define REG_PM_TOP_54_H         (REG_PM_TOP_BASE + 0xA9)
#define REG_PM_TOP_55_L         (REG_PM_TOP_BASE + 0xAA)
#define REG_PM_TOP_55_H         (REG_PM_TOP_BASE + 0xAB)
#define REG_PM_TOP_56_L         (REG_PM_TOP_BASE + 0xAC)
#define REG_PM_TOP_56_H         (REG_PM_TOP_BASE + 0xAD)
#define REG_PM_TOP_57_L         (REG_PM_TOP_BASE + 0xAE)
#define REG_PM_TOP_57_H         (REG_PM_TOP_BASE + 0xAF)
#define REG_PM_TOP_58_L         (REG_PM_TOP_BASE + 0xB0)
#define REG_PM_TOP_58_H         (REG_PM_TOP_BASE + 0xB1)
#define REG_PM_TOP_59_L         (REG_PM_TOP_BASE + 0xB2)
#define REG_PM_TOP_59_H         (REG_PM_TOP_BASE + 0xB3)
#define REG_PM_TOP_5A_L         (REG_PM_TOP_BASE + 0xB4)
#define REG_PM_TOP_5A_H         (REG_PM_TOP_BASE + 0xB5)
#define REG_PM_TOP_5B_L         (REG_PM_TOP_BASE + 0xB6)
#define REG_PM_TOP_5B_H         (REG_PM_TOP_BASE + 0xB7)
#define REG_PM_TOP_5C_L         (REG_PM_TOP_BASE + 0xB8)
#define REG_PM_TOP_5C_H         (REG_PM_TOP_BASE + 0xB9)
#define REG_PM_TOP_5D_L         (REG_PM_TOP_BASE + 0xBA)
#define REG_PM_TOP_5D_H         (REG_PM_TOP_BASE + 0xBB)
#define REG_PM_TOP_5E_L         (REG_PM_TOP_BASE + 0xBC)
#define REG_PM_TOP_5E_H         (REG_PM_TOP_BASE + 0xBD)
#define REG_PM_TOP_5F_L         (REG_PM_TOP_BASE + 0xBE)
#define REG_PM_TOP_5F_H         (REG_PM_TOP_BASE + 0xBF)
#define REG_PM_TOP_60_L         (REG_PM_TOP_BASE + 0xC0)
#define REG_PM_TOP_60_H         (REG_PM_TOP_BASE + 0xC1)
#define REG_PM_TOP_61_L         (REG_PM_TOP_BASE + 0xC2)
#define REG_PM_TOP_61_H         (REG_PM_TOP_BASE + 0xC3)
#define REG_PM_TOP_62_L         (REG_PM_TOP_BASE + 0xC4)
#define REG_PM_TOP_62_H         (REG_PM_TOP_BASE + 0xC5)
#define REG_PM_TOP_63_L         (REG_PM_TOP_BASE + 0xC6)
#define REG_PM_TOP_63_H         (REG_PM_TOP_BASE + 0xC7)
#define REG_PM_TOP_64_L         (REG_PM_TOP_BASE + 0xC8)
#define REG_PM_TOP_64_H         (REG_PM_TOP_BASE + 0xC9)
#define REG_PM_TOP_65_L         (REG_PM_TOP_BASE + 0xCA)
#define REG_PM_TOP_65_H         (REG_PM_TOP_BASE + 0xCB)
#define REG_PM_TOP_66_L         (REG_PM_TOP_BASE + 0xCC)
#define REG_PM_TOP_66_H         (REG_PM_TOP_BASE + 0xCD)
#define REG_PM_TOP_67_L         (REG_PM_TOP_BASE + 0xCE)
#define REG_PM_TOP_67_H         (REG_PM_TOP_BASE + 0xCF)
#define REG_PM_TOP_68_L         (REG_PM_TOP_BASE + 0xD0)
#define REG_PM_TOP_68_H         (REG_PM_TOP_BASE + 0xD1)
#define REG_PM_TOP_69_L         (REG_PM_TOP_BASE + 0xD2)
#define REG_PM_TOP_69_H         (REG_PM_TOP_BASE + 0xD3)
#define REG_PM_TOP_6A_L         (REG_PM_TOP_BASE + 0xD4)
#define REG_PM_TOP_6A_H         (REG_PM_TOP_BASE + 0xD5)
#define REG_PM_TOP_6B_L         (REG_PM_TOP_BASE + 0xD6)
#define REG_PM_TOP_6B_H         (REG_PM_TOP_BASE + 0xD7)
#define REG_PM_TOP_6C_L         (REG_PM_TOP_BASE + 0xD8)
#define REG_PM_TOP_6C_H         (REG_PM_TOP_BASE + 0xD9)
#define REG_PM_TOP_6D_L         (REG_PM_TOP_BASE + 0xDA)
#define REG_PM_TOP_6D_H         (REG_PM_TOP_BASE + 0xDB)
#define REG_PM_TOP_6E_L         (REG_PM_TOP_BASE + 0xDC)
#define REG_PM_TOP_6E_H         (REG_PM_TOP_BASE + 0xDD)
#define REG_PM_TOP_6F_L         (REG_PM_TOP_BASE + 0xDE)
#define REG_PM_TOP_6F_H         (REG_PM_TOP_BASE + 0xDF)
#define REG_PM_TOP_70_L         (REG_PM_TOP_BASE + 0xE0)
#define REG_PM_TOP_70_H         (REG_PM_TOP_BASE + 0xE1)
#define REG_PM_TOP_71_L         (REG_PM_TOP_BASE + 0xE2)
#define REG_PM_TOP_71_H         (REG_PM_TOP_BASE + 0xE3)
#define REG_PM_TOP_72_L         (REG_PM_TOP_BASE + 0xE4)
#define REG_PM_TOP_72_H         (REG_PM_TOP_BASE + 0xE5)
#define REG_PM_TOP_73_L         (REG_PM_TOP_BASE + 0xE6)
#define REG_PM_TOP_73_H         (REG_PM_TOP_BASE + 0xE7)
#define REG_PM_TOP_74_L         (REG_PM_TOP_BASE + 0xE8)
#define REG_PM_TOP_74_H         (REG_PM_TOP_BASE + 0xE9)
#define REG_PM_TOP_75_L         (REG_PM_TOP_BASE + 0xEA)
#define REG_PM_TOP_75_H         (REG_PM_TOP_BASE + 0xEB)
#define REG_PM_TOP_76_L         (REG_PM_TOP_BASE + 0xEC)
#define REG_PM_TOP_76_H         (REG_PM_TOP_BASE + 0xED)
#define REG_PM_TOP_77_L         (REG_PM_TOP_BASE + 0xEE)
#define REG_PM_TOP_77_H         (REG_PM_TOP_BASE + 0xEF)
#define REG_PM_TOP_78_L         (REG_PM_TOP_BASE + 0xF0)
#define REG_PM_TOP_78_H         (REG_PM_TOP_BASE + 0xF1)
#define REG_PM_TOP_79_L         (REG_PM_TOP_BASE + 0xF2)
#define REG_PM_TOP_79_H         (REG_PM_TOP_BASE + 0xF3)
#define REG_PM_TOP_7A_L         (REG_PM_TOP_BASE + 0xF4)
#define REG_PM_TOP_7A_H         (REG_PM_TOP_BASE + 0xF5)
#define REG_PM_TOP_7B_L         (REG_PM_TOP_BASE + 0xF6)
#define REG_PM_TOP_7B_H         (REG_PM_TOP_BASE + 0xF7)
#define REG_PM_TOP_7C_L         (REG_PM_TOP_BASE + 0xF8)
#define REG_PM_TOP_7C_H         (REG_PM_TOP_BASE + 0xF9)
#define REG_PM_TOP_7D_L         (REG_PM_TOP_BASE + 0xFA)
#define REG_PM_TOP_7D_H         (REG_PM_TOP_BASE + 0xFB)
#define REG_PM_TOP_7E_L         (REG_PM_TOP_BASE + 0xFC)
#define REG_PM_TOP_7E_H         (REG_PM_TOP_BASE + 0xFD)
#define REG_PM_TOP_7F_L         (REG_PM_TOP_BASE + 0xFE)
#define REG_PM_TOP_7F_H         (REG_PM_TOP_BASE + 0xFF)



#endif /* __HAL_PNL_REG_H__ */
